package ru.yandex.chemodan.app.dataapi.web.profile.yatickets.orders;

import ru.yandex.chemodan.app.dataapi.NS;
import ru.yandex.chemodan.app.dataapi.apps.profile.yatickets.OrdersManager;
import ru.yandex.chemodan.app.dataapi.apps.profile.yatickets.model.Order;
import ru.yandex.chemodan.app.dataapi.web.rest.ProxyInterceptor;
import ru.yandex.chemodan.util.web.BenderJsonParameterBinder;
import ru.yandex.commune.a3.action.Action;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.intercept.InterceptWith;
import ru.yandex.commune.a3.action.invoke.ActionInvocationContext;
import ru.yandex.commune.a3.action.parameter.bind.annotation.BindWith;
import ru.yandex.commune.a3.action.parameter.bind.annotation.SpecialParam;
import ru.yandex.misc.db.masterSlave.MasterSlavePolicy;
import ru.yandex.misc.db.masterSlave.WithMasterSlavePolicy;
import ru.yandex.misc.io.http.HttpStatus;

/**
 * @author Denis Bakharev
 */
@Action(
        value = @Action.Alias(value = "post-order", namespace = NS.PROFILE),
        description = "Создать заказ на билет")
@Path(value = "/ya-tickets/orders", methods = HttpMethod.POST)
@InterceptWith(value = ProxyInterceptor.class)
@WithMasterSlavePolicy(MasterSlavePolicy.RW_M)
public class CreateOrderAction extends OrdersActionBase {

    @SpecialParam
    private ActionInvocationContext context;

    @BindWith(value = BenderJsonParameterBinder.class)
    private Order order;

    public CreateOrderAction(OrdersManager ordersManager) {
        super(ordersManager);
    }

    @Override
    public Order execute() throws Exception {
        ordersManager.insertEntity(user, order);
        context.getHttpContext().setStatusCode(HttpStatus.SC_201_CREATED);
        return order;
    }
}
