package ru.yandex.chemodan.app.dataapi.web.profile.yatickets.orders;

import ru.yandex.chemodan.app.dataapi.NS;
import ru.yandex.chemodan.app.dataapi.apps.profile.yatickets.OrdersManager;
import ru.yandex.chemodan.app.dataapi.apps.profile.yatickets.model.Order;
import ru.yandex.chemodan.app.dataapi.web.rest.ProxyInterceptor;
import ru.yandex.chemodan.util.web.OkPojo;
import ru.yandex.commune.a3.action.Action;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.intercept.InterceptWith;
import ru.yandex.commune.a3.action.invoke.ActionInvocationContext;
import ru.yandex.commune.a3.action.parameter.bind.annotation.PathParam;
import ru.yandex.commune.a3.action.parameter.bind.annotation.SpecialParam;
import ru.yandex.misc.db.masterSlave.MasterSlavePolicy;
import ru.yandex.misc.db.masterSlave.WithMasterSlavePolicy;

/**
 * @author Denis Bakharev
 */
@Action(
        value = @Action.Alias(value = "delete-order", namespace = NS.PROFILE),
        description = "Удалить существующий заказ на билет")
@Path(value = "/ya-tickets/orders/{orderId}", methods = HttpMethod.DELETE)
@InterceptWith(value = ProxyInterceptor.class)
@WithMasterSlavePolicy(MasterSlavePolicy.RW_M)
public class DeleteOrderAction extends OrdersActionBase {

    @SpecialParam
    private ActionInvocationContext context;

    @PathParam
    private String orderId;

    public DeleteOrderAction(OrdersManager ordersManager) {
        super(ordersManager);
    }

    @Override
    public OkPojo execute() throws Exception {
        // 404 for non-existing orders
        Order existingOrder = ordersManager.getEntityByUidAndId(user, orderId);

        ordersManager.deleteEntity(user, orderId);
        return new OkPojo();
    }
}
