package ru.yandex.chemodan.app.dataapi.web.profile.yatickets.orders;

import ru.yandex.chemodan.app.dataapi.NS;
import ru.yandex.chemodan.app.dataapi.apps.profile.full.CachedFullProfileManager;
import ru.yandex.chemodan.app.dataapi.apps.profile.full.FullUserProfile;
import ru.yandex.chemodan.app.dataapi.apps.profile.yatickets.model.Order;
import ru.yandex.chemodan.app.dataapi.web.NotFoundException;
import ru.yandex.chemodan.app.dataapi.web.profile.GetProfilePartActionSupport;
import ru.yandex.commune.a3.action.Action;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.PathParam;
import ru.yandex.misc.db.masterSlave.MasterSlavePolicy;
import ru.yandex.misc.db.masterSlave.WithMasterSlavePolicy;

/**
 * @author Denis Bakharev
 */
@Action(
        value = @Action.Alias(value = "get-order", namespace = NS.PROFILE),
        description = "Получить заказ на билет")
@Path(value = "/ya-tickets/orders/{orderId}", methods = HttpMethod.GET)
@WithMasterSlavePolicy(MasterSlavePolicy.R_ANY)
public class GetOrderAction extends GetProfilePartActionSupport<Order> {

    @PathParam
    private String orderId;

    public GetOrderAction(CachedFullProfileManager cachedFullProfileManager) {
        super(cachedFullProfileManager, true);
    }

    @Override
    public Order getFromFullProfile(FullUserProfile profile) {
        return profile.yaTicketOrders.orders
                .find(order -> order.orderId.equals(orderId))
                .getOrThrow(NotFoundException.consF("Order not found"));
    }
}
