package ru.yandex.chemodan.app.dataapi.web.profile.yatickets.orders;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.dataapi.NS;
import ru.yandex.chemodan.app.dataapi.apps.profile.full.CachedFullProfileManager;
import ru.yandex.chemodan.app.dataapi.apps.profile.full.FullUserProfile;
import ru.yandex.chemodan.app.dataapi.apps.profile.yatickets.model.Order;
import ru.yandex.chemodan.app.dataapi.web.profile.GetProfilePartActionSupport;
import ru.yandex.commune.a3.action.Action;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.result.pojo.ActionResultPojo;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.db.masterSlave.MasterSlavePolicy;
import ru.yandex.misc.db.masterSlave.WithMasterSlavePolicy;

/**
 * @author Denis Bakharev
 */
@Action(
        value = @Action.Alias(value = "get-orders", namespace = NS.PROFILE),
        description = "Получить все заказы на билет")
@Path(value = "/ya-tickets/orders", methods = HttpMethod.GET)
@Path(value = "/platform/personality/profile/ya-tickets/orders", methods = HttpMethod.GET)
@WithMasterSlavePolicy(MasterSlavePolicy.R_ANY)
public class GetOrdersAction extends GetProfilePartActionSupport<GetOrdersAction.ListOrdersPojo> {

    public GetOrdersAction(CachedFullProfileManager profileManager) {
        super(profileManager);
    }

    @Override
    public ListOrdersPojo getFromFullProfile(FullUserProfile profile) {
        return new ListOrdersPojo(profile.yaTicketOrders.orders);
    }

    @BenderBindAllFields
    @ActionResultPojo
    static final class ListOrdersPojo {
        public final ListF<Order> items;

        private ListOrdersPojo(ListF<Order> items) {
            this.items = items;
        }
    }
}
