package ru.yandex.chemodan.app.dataapi.web.profile.yatickets.orders;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.chemodan.app.dataapi.apps.profile.full.CachedFullProfileManager;
import ru.yandex.chemodan.app.dataapi.apps.profile.yatickets.OrdersManager;

/**
 * @author Denis Bakharev
 */
@Configuration
public class OrdersActionsContextConfiguration {
    @Bean
    public CreateOrderAction createOrderAction(OrdersManager ordersManager) {
        return new CreateOrderAction(ordersManager);
    }

    @Bean
    public SetOrderAction setOrderAction(OrdersManager ordersManager) {
        return new SetOrderAction(ordersManager);
    }

    @Bean
    public GetOrderAction getOrderAction(CachedFullProfileManager profileManager) {
        return new GetOrderAction(profileManager);
    }

    @Bean
    public GetOrdersAction getOrdersAction(CachedFullProfileManager profileManager) {
        return new GetOrdersAction(profileManager);
    }

    @Bean
    public DeleteOrderAction deleteOrderAction(OrdersManager ordersManager) {
        return new DeleteOrderAction(ordersManager);
    }
}
