package ru.yandex.chemodan.app.dataapi.web.profile.yatickets.orders;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.NS;
import ru.yandex.chemodan.app.dataapi.apps.profile.yatickets.OrdersManager;
import ru.yandex.chemodan.app.dataapi.apps.profile.yatickets.model.Order;
import ru.yandex.chemodan.app.dataapi.web.rest.ProxyInterceptor;
import ru.yandex.chemodan.util.exception.A3ExceptionWithStatus;
import ru.yandex.chemodan.util.web.BenderJsonParameterBinder;
import ru.yandex.commune.a3.action.Action;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.intercept.InterceptWith;
import ru.yandex.commune.a3.action.invoke.ActionInvocationContext;
import ru.yandex.commune.a3.action.parameter.bind.annotation.BindWith;
import ru.yandex.commune.a3.action.parameter.bind.annotation.PathParam;
import ru.yandex.commune.a3.action.parameter.bind.annotation.SpecialParam;
import ru.yandex.misc.db.masterSlave.MasterSlavePolicy;
import ru.yandex.misc.db.masterSlave.WithMasterSlavePolicy;
import ru.yandex.misc.io.http.HttpStatus;

/**
 * @author Denis Bakharev
 */
@Action(
        value = @Action.Alias(value = "set-order", namespace = NS.PROFILE),
        description = "Изменить существующий или создать новый заказ на билет")
@Path(value = "/ya-tickets/orders/{orderId}", methods = HttpMethod.PUT)
@InterceptWith(value = ProxyInterceptor.class)
@WithMasterSlavePolicy(MasterSlavePolicy.RW_M)
public class SetOrderAction extends OrdersActionBase {

    @SpecialParam
    private ActionInvocationContext context;

    @BindWith(value = BenderJsonParameterBinder.class)
    private Order order;

    @PathParam
    private String orderId;

    public SetOrderAction(OrdersManager ordersManager) {
        super(ordersManager);
    }

    @Override
    public Order execute() throws Exception {
        if (!orderId.equals(order.getOrderId())) {
            throw new A3ExceptionWithStatus(ru.yandex.chemodan.util.web.ErrorNames.BAD_REQUEST,
                    "order id in request must be equal with order id in url", HttpStatus.SC_400_BAD_REQUEST);
        }

        Option<Order> oldOrderO = ordersManager.getEntityByUidAndIdO(user, orderId);
        ordersManager.setEntity(user, order);

        context.getHttpContext()
                .setStatusCode(oldOrderO.isPresent() ? HttpStatus.SC_200_OK : HttpStatus.SC_201_CREATED);

        return order;
    }
}
