package ru.yandex.chemodan.app.dataapi.web.ratelimiter;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.ratelimiter.yarl.YarlHttpClient;
import ru.yandex.chemodan.ratelimiter.yarl.YarlRateLimiterHttpClientContextConfiguration;
import ru.yandex.commune.alive2.AliveAppInfo;
import ru.yandex.commune.dynproperties.DynamicProperty;

/**
 * @author friendlyevil
 */
@Configuration
@Import({
        YarlRateLimiterHttpClientContextConfiguration.class,
})
public class RateLimiterConfiguration {

    private final DynamicProperty<Boolean> yarlIsDryRun =
            new DynamicProperty<>("yarl.dryRun", true);

    private final DynamicProperty<Boolean> yarlIsEnabled =
            new DynamicProperty<>("yarl.enabled", false);

    private final DynamicProperty<Boolean> yarlIsWhiteListMode =
            new DynamicProperty<>("yarl.use.whitelist.mode", true);

    private final DynamicProperty<ListF<String>> yarlEnabledForClients =
            new DynamicProperty<>("yarl.enabled.clients", Cf.arrayList());

    private final DynamicProperty<ListF<String>> yarlDisabledForClients =
            new DynamicProperty<>("yarl.disabled.clients", Cf.arrayList());

    private final DynamicProperty<Boolean> perDcEnabled =
            new DynamicProperty<>("dataapi-yarl.per-dc-counter.enabled",false);
    private final DynamicProperty<Boolean> perDcForAllClients =
            new DynamicProperty<>("dataapi-yarl.per-dc-counter.for-all-clients",false);
    private final DynamicProperty<ListF<String>> perDcForClients =
            new DynamicProperty<>("dataapi-yarl.per-dc-counter.for-clients", Cf.arrayList());

    @Bean
    public DataapiRateLimiterInterceptor dataapiRateLimiterInterceptor(YarlHttpClient yarlHttpClient, AliveAppInfo aliveAppInfo) {
        return new DataapiRateLimiterInterceptor(yarlHttpClient, yarlIsDryRun::get, yarlIsEnabled::get,
                yarlIsWhiteListMode::get, yarlEnabledForClients::get, yarlDisabledForClients::get, aliveAppInfo,
                perDcEnabled::get, perDcForAllClients::get, perDcForClients::get);
    }
}
