package ru.yandex.chemodan.app.dataapi.web.rest;

import lombok.Value;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.dataapi.core.dao.DataApiShardResolver;
import ru.yandex.chemodan.app.dataapi.core.dao.UserShardInfo;
import ru.yandex.chemodan.app.dataapi.core.dao.support.TransactionUserShardIdHolder;
import ru.yandex.chemodan.http.proxy.MasterDcHostResolver;
import ru.yandex.chemodan.util.sharpei.UserId;
import ru.yandex.commune.alive2.location.DcUtils;
import ru.yandex.commune.db.shard2.Shard2;
import ru.yandex.commune.db.shard2.ShardManager2;

/**
 * @author vpronto
 */
@Value
public class MasterDcHostResolverSharpei implements MasterDcHostResolver {

    private final ShardManager2 shardManager2;
    private final DataApiShardResolver shardResolver;

    @Override
    public Option<String> resolveMasterHost(UserId userId) {
        return resolveMasterHost((DataApiUserId) userId);
    }

    public Option<String> resolveMasterHost(DataApiUserId userId) {
        Option<Shard2> shard = getShard(userId);
        return shard.filterMap(s -> DcUtils.getDcDirtyO(s.getShardInfo().getWriterHostPortDbname()));
    }

    private Option<Shard2> getShard(DataApiUserId user) {
        if (TransactionUserShardIdHolder.holdsUser(user)) {
            return Option.ofNullable(shardManager2.getShard(TransactionUserShardIdHolder.getHoldingShardId()));
        }
        Option<UserShardInfo> shard = shardResolver.shardByUserIdO(user, true);
        return shard.filterNot(s -> s.userIsInRo).map(s -> shardManager2.getShard(s.shardId));
    }
}
