package ru.yandex.chemodan.app.dataapi.web.rest;

import java.lang.reflect.Method;

import org.joda.time.Instant;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.test.context.ContextConfiguration;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.core.dao.test.ActivateDataApiEmbeddedPg;
import ru.yandex.chemodan.app.dataapi.test.TestConstants;
import ru.yandex.chemodan.app.dataapi.web.test.ApiTestBase;
import ru.yandex.chemodan.http.proxy.AccelProxy;
import ru.yandex.chemodan.http.proxy.MasterDcHostResolver;
import ru.yandex.chemodan.http.proxy.ProxyManager;
import ru.yandex.commune.alive2.AliveAppInfo;
import ru.yandex.commune.alive2.AliveAppsContextConfiguration;
import ru.yandex.commune.alive2.AliveAppsHolder;
import ru.yandex.misc.lang.StringUtils;
import ru.yandex.misc.test.Assert;
import ru.yandex.misc.web.servlet.mock.MockHttpServletResponse;

@ContextConfiguration(classes = {
        MasterDcHostResolverSharpeiTest.Context.class,
})
@ActivateDataApiEmbeddedPg
public class MasterDcHostResolverSharpeiTest extends ApiTestBase {

    @Autowired
    ProxyManager proxyManager;

    @Test
    public void testRedirectPutWithAccel() throws Exception {
        Method method = proxyManager.allHostsRedirect.getClass().getDeclaredMethod("set", Object.class);
        method.setAccessible(true);
        method.invoke(proxyManager.allHostsRedirect, true);

        String url = StringUtils.format("/databases/{}/diffs?__uid={}&app={}&rev=0",
                TestConstants.EXT_DB_ALIAS_RW.aliasId(),
                uid.toString(),
                TestConstants.EXT_DB_ALIAS_RW.clientAppName());

        String content =
                "{\n"
                        + "    \"id\":\"A\",\n"
                        + "    \"changes\":[\n"
                        + "        {\n"
                        + "            \"op\":\"set\",\n"
                        + "            \"collectionId\":\"B\",\n"
                        + "            \"recordId\":\"C\",\n"
                        + "            \"data\":{\n"
                        + "                \"D\":\"E\"\n"
                        + "            }\n"
                        + "        }\n"
                        + "    ]\n"
                        + "}";
        MockHttpServletResponse resp = sendRequestUsual("PUT", url, content);
        assertSuccess(resp);
    }

    private void assertSuccess(MockHttpServletResponse resp) {
        Assert.equals(204, resp.getStatus());
        Assert.isTrue(resp.getHeader(AccelProxy.ACCEL_REDIRECT).startsWith("/proxy_put"));
    }

    @Override
    protected String getNamespace() {
        return ru.yandex.chemodan.util.web.NS.API;
    }

    @Configuration
    @Import({
            AliveAppsContextConfiguration.class
    })
    public static class Context {

        @Bean
        public MasterDcHostResolver masterDcHostResolver()
        {
            return userId -> Option.of("IVA");
        }

        @Bean
        public ProxyManager proxyManager(AliveAppInfo appName, MasterDcHostResolver masterDcHostResolver) {
            AliveAppsHolder aliveAppsHolder = new AliveAppsHolder();
            aliveAppsHolder.listChanged(Cf.list(createAliveApp(appName)));
            return new ProxyManager(masterDcHostResolver,
                    new AccelProxy(),
                    aliveAppsHolder,
                    appName);
        }

        private AliveAppInfo createAliveApp(AliveAppInfo appName) {
            return new AliveAppInfo(appName.getServiceName(),
                    appName.getAppName(),
                    Instant.now(),
                    appName.getVersion(),
                    "right-1",
                    1,
                    appName.getState(),
                    Option.of("IVA"));
        }

        @Bean
        public ProxyInterceptor proxyInterceptor(ProxyManager proxyManager) {
            return new ProxyInterceptor(proxyManager);
        }
    }
}
