package ru.yandex.chemodan.app.dataapi.web.rest;

import java.util.Optional;
import java.util.stream.Stream;

import lombok.Value;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.dataapi.web.auth.SetUserAndAppInfoInterceptorBase;
import ru.yandex.chemodan.app.dataapi.web.auth.UserAndAppInfo;
import ru.yandex.chemodan.app.dataapi.web.batch.BatchRequest;
import ru.yandex.chemodan.app.dataapi.web.batch.BatchRequestItem;
import ru.yandex.chemodan.http.proxy.ProxyContent;
import ru.yandex.chemodan.http.proxy.ProxyManager;
import ru.yandex.chemodan.web.InterceptorOrders;
import ru.yandex.commune.a3.action.intercept.ActionInvocationInterceptor;
import ru.yandex.commune.a3.action.intercept.ExplicitInterceptor;
import ru.yandex.commune.a3.action.invoke.ActionInvocation;
import ru.yandex.commune.dynproperties.DynamicProperty;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.regex.Pattern2;

/**
 * @author vpronto
 * POC should be refactored
 */
@ExplicitInterceptor
@Value
public class ProxyBatchInterceptor implements ActionInvocationInterceptor {

    private static final Logger logger = LoggerFactory.getLogger(ProxyBatchInterceptor.class);
    public static final Pattern2 pattern = Pattern2.compile("uid=([^&$]+)&{0,1}");

    public final DynamicProperty<Boolean> batchProxy = new DynamicProperty<>(
            "proxy-forwarded.enabled.batch", false
    );

    private final ProxyManager proxyManager;

    @Override
    public Object intercept(ActionInvocation invocation) throws Exception {
        Option<String> proxied = Option.empty();
        if (batchProxy.get() && proxyManager.shouldProxy(invocation.getWebRequest())) {
            try {
                Option<DataApiUserId> uidO = findUid(invocation);
                if (uidO.isPresent()) {
                    proxied = proxyManager.proxyInner(invocation.getWebRequest(), uidO.get());
                }
            } catch (Exception e) {
                logger.warn("Error during proxying: {}", e.getMessage());
            }
        }
        if (!proxied.isPresent()) {
            return invocation.invoke();
        }
        logger.debug("Skipped execution, bypassed to proxy: {}", proxied.get());
        return ProxyContent.cons();
    }

    private Option<DataApiUserId> findUid(ActionInvocation invocation) {

        //first check that request is not read only
        boolean isMethodAllowed = isMethodAllowed(invocation);
        if (!isMethodAllowed) {
            return Option.empty();
        }
        //check platform requests
        UserAndAppInfo info = SetUserAndAppInfoInterceptorBase.getInfo(invocation.getContext());
        if (info.uid.isPresent()) {
            return info.uid;
        }
        //check rest requests
        Optional<String> first = getStream(invocation)
                .map(s -> s.relativeUrl)
                .map(s -> pattern.matcher2(s))
                .filter(p -> p.find(1))
                .map(p -> p.group(1).get())
                .findAny();
        return Option.x(first).map(DataApiUserId::parse);
    }

    private Stream<BatchRequestItem> getStream(ActionInvocation invocation) {
        return invocation.getParameters().stream().filter(parameter -> parameter.getValue().isPresent())
                .filter(p -> p.getValue().get() instanceof BatchRequest)
                .flatMap(p -> ((BatchRequest) p.getValue().get()).items.stream());
    }

    private boolean isMethodAllowed(ActionInvocation invocation) {
        ListF<String> enabledMethods = proxyManager.getEnabledMethods().get();
        return getStream(invocation)
                .filter(s -> enabledMethods.containsTs(s.method.toUpperCase()))
                .findAny().isPresent();
    }

    @Override
    public int getOrder() {
        return InterceptorOrders.PROXY_INTERCEPTOR_ORDER;
    }

}
