package ru.yandex.chemodan.app.dataapi.web.rest;

import org.junit.Test;

import ru.yandex.misc.regex.Matcher2;
import ru.yandex.misc.regex.Pattern2;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;

public class ProxyBatchInterceptorTest {

    @Test
    public void testRegexp() {
        Pattern2 pattern = ProxyBatchInterceptor.pattern;
        testFind(pattern.matcher2("/v1/platform/batch?uid=1"));
        testFind(pattern.matcher2("/v1/platform/batch?uid=1&some=2"));
        testFind(pattern.matcher2("/v1/platform/batch?some=2&uid=1"));
        testFind(pattern.matcher2("/v1/platform/batch?some=2&__uid=1"));
        testFind(pattern.matcher2("/v1/platform/batch?__uid=1&some=2"));
        assertFalse(pattern.matcher2("/v1/platform/batch?__id=1&some=2").find());
    }

    private void testFind(Matcher2 matcher) {
        assertTrue(matcher.find(1));
        assertEquals(matcher.group(1).get(), "1");
    }
}
