package ru.yandex.chemodan.app.dataapi.web.rest;

import lombok.Value;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.web.auth.SetUserAndAppInfoInterceptorBase;
import ru.yandex.chemodan.app.dataapi.web.auth.UserAndAppInfo;
import ru.yandex.chemodan.http.proxy.ProxyContent;
import ru.yandex.chemodan.http.proxy.ProxyManager;
import ru.yandex.chemodan.web.InterceptorOrders;
import ru.yandex.commune.a3.action.intercept.ActionInvocationInterceptor;
import ru.yandex.commune.a3.action.intercept.ExplicitInterceptor;
import ru.yandex.commune.a3.action.invoke.ActionInvocation;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author vpronto
 */
@ExplicitInterceptor
@Value
public class ProxyInterceptor implements ActionInvocationInterceptor {

    private final Logger logger = LoggerFactory.getLogger(ProxyInterceptor.class);
    private final ProxyManager proxyManager;

    @Override
    public Object intercept(ActionInvocation invocation) throws Exception {
        UserAndAppInfo info = SetUserAndAppInfoInterceptorBase.getInfo(invocation.getContext());
        Option<String> proxied = Option.empty();
        if (info.uid.isPresent()) {
            proxied = proxyManager.proxy(invocation.getWebRequest(), info.uid.get());
        }
        if (!proxied.isPresent()) { return invocation.invoke(); }
        logger.debug("Skipped execution, bypassed to proxy: {}", proxied.get());
        return ProxyContent.cons();
    }

    @Override
    public int getOrder() {
        return InterceptorOrders.PROXY_INTERCEPTOR_ORDER;
    }

}
