package ru.yandex.chemodan.app.dataapi.web.xiva;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.core.xiva.XivaUrlHelper;
import ru.yandex.chemodan.app.dataapi.web.pojo.XivaSubscriptionUrlPojo;
import ru.yandex.commune.a3.action.Action;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.ValidateParam;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.misc.db.masterSlave.MasterSlavePolicy;
import ru.yandex.misc.db.masterSlave.WithMasterSlavePolicy;

/**
 * @author metal
 */
@Action(
        value = @Action.Alias(value = "get-app-subscription-url", namespace = ru.yandex.chemodan.util.web.NS.API),
        description = "Получить ссылку для подписки на уведомления об изменениях баз для приложений")
@Path(value = "/databases/subscribe/app", methods = HttpMethod.GET)
@WithMasterSlavePolicy(MasterSlavePolicy.R_ANY)
public class GetApplicationSubscriptionUrlAction extends GetSubscriptionUrlAction {
    private static final String PARAMETER_VALIDATION_ERROR_MESSAGE = "app or (client and deviceId) should be not empty";

    @RequestParam(value = "app")
    private Option<String> app;

    @RequestParam(value = "client")
    private Option<String> client;

    @RequestParam(value = "deviceId")
    private Option<String> deviceId;

    @RequestParam(value = "platform")
    private String platform;

    @RequestParam(value = "platformPushToken")
    private String platformPushToken;

    @RequestParam(value = "session")
    private Option<String> session;

    @RequestParam(value = "databaseIds")
    private String databaseIds;

    public GetApplicationSubscriptionUrlAction(XivaUrlHelper xivaUrlHelper) {
        super(xivaUrlHelper);
    }

    @Override
    public XivaSubscriptionUrlPojo execute() throws Exception {

        if (!client.isPresent() || !deviceId.isPresent()) {
            ValidateParam.notBlank("app", app.getOrElse(""), PARAMETER_VALIDATION_ERROR_MESSAGE);
        } else {
            ValidateParam.notBlank("client", client.getOrElse(""), PARAMETER_VALIDATION_ERROR_MESSAGE);
            ValidateParam.notBlank("deviceId", deviceId.getOrElse(""), PARAMETER_VALIDATION_ERROR_MESSAGE);
        }

        String url = xivaUrlHelper.getApplicationSubscriptionUrl(app, client, getSession(session),
                deviceId, platform, platformPushToken, getServicesWithTags(databaseIds));
        return new XivaSubscriptionUrlPojo(url);
    }
}
