package ru.yandex.chemodan.app.dataapi.web.xiva;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.core.xiva.XivaUrlHelper;
import ru.yandex.chemodan.app.dataapi.web.pojo.XivaSubscriptionUrlPojo;
import ru.yandex.commune.a3.action.Action;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.misc.db.masterSlave.MasterSlavePolicy;
import ru.yandex.misc.db.masterSlave.WithMasterSlavePolicy;

/**
 * @author metal
 */
@Action(
        value = @Action.Alias(value = "get-callback-subscription-url", namespace = ru.yandex.chemodan.util.web.NS.API),
        description = "Получить ссылку для подписки на уведомления об изменениях баз по callback")
@Path(value = "/databases/subscribe/url", methods = HttpMethod.GET)
@WithMasterSlavePolicy(MasterSlavePolicy.R_ANY)
public class GetCallbackSubscriptionUrlAction extends GetSubscriptionUrlAction {
    @RequestParam(value = "ctoken")
    private String ctoken;

    @RequestParam(value = "callback")
    private String callback;

    @RequestParam(value = "session")
    private Option<String> session;

    @RequestParam(value = "databaseIds")
    private String databaseIds;

    public GetCallbackSubscriptionUrlAction(XivaUrlHelper xivaUrlHelper) {
        super(xivaUrlHelper);
    }

    @Override
    public XivaSubscriptionUrlPojo execute() throws Exception {
        try {
            String url = xivaUrlHelper.getCallbackSubscriptionUrl(user, ctoken, callback, getSession(session),
                    getServicesWithTags(databaseIds));
            return new XivaSubscriptionUrlPojo(url);
        } catch (IllegalArgumentException e) {
            throw new UnsupportedOperationException();
        }
    }
}
