package ru.yandex.chemodan.app.dataapi.web.xiva;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.core.xiva.XivaUrlHelper;
import ru.yandex.chemodan.app.dataapi.web.pojo.XivaSubscriptionUrlPojo;
import ru.yandex.commune.a3.action.Action;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.misc.db.masterSlave.MasterSlavePolicy;
import ru.yandex.misc.db.masterSlave.WithMasterSlavePolicy;

/**
 * @author metal
 */
@Action(
        value = @Action.Alias(value = "get-stream-subscription-url", namespace = ru.yandex.chemodan.util.web.NS.API),
        description = "Получить ссылку для подписки на уведомления об изменениях баз через браузер через WebSocket-соединение")
@Path(value = "/databases/subscribe", methods = HttpMethod.GET)
@WithMasterSlavePolicy(MasterSlavePolicy.R_ANY)
public class GetStreamSubscriptionUrlAction extends GetSubscriptionUrlAction {
    @RequestParam(value = "oauthToken")
    private Option<String> oauthToken;

    @RequestParam(value = "client")
    private String client;

    @RequestParam(value = "session")
    private Option<String> session;

    @RequestParam(value = "tld")
    private Option<String> tld;

    @RequestParam(value = "databaseIds")
    private String databaseIds;

    public GetStreamSubscriptionUrlAction(XivaUrlHelper xivaUrlHelper) {
        super(xivaUrlHelper);
    }

    @Override
    public XivaSubscriptionUrlPojo execute() throws Exception {
        try {
            String url = xivaUrlHelper.getStreamSubscriptionUrl(oauthToken, user, client, getSession(session),
                    getServicesWithTags(databaseIds), tld);
            return new XivaSubscriptionUrlPojo(url);
        } catch (IllegalArgumentException e) {
            throw new UnsupportedOperationException();
        }
    }
}
