package ru.yandex.chemodan.app.dataapi.web.xiva;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.core.xiva.XivaUrlHelper;
import ru.yandex.chemodan.app.dataapi.web.DataApiActionBase;
import ru.yandex.misc.lang.StringUtils;
import ru.yandex.misc.random.Random2;

/**
 * @author metal
 */
public abstract class GetSubscriptionUrlAction extends DataApiActionBase {
    protected static final String SERVICE = "datasync";

    protected XivaUrlHelper xivaUrlHelper;

    public GetSubscriptionUrlAction(XivaUrlHelper xivaUrlHelper) {
        this.xivaUrlHelper = xivaUrlHelper;
    }

    protected MapF<String, ListF<String>> getServicesWithTags(String databaseIds) {
        ListF<String> tags = StringUtils.isBlank(databaseIds) ? Cf.list() : Cf.list(databaseIds.split(","));
        MapF<String, ListF<String>> servicesWithTags = Cf.hashMap();
        servicesWithTags.put(SERVICE, tags);
        return servicesWithTags;
    }

    protected String getSession(Option<String> session) {
        return session.isPresent() ? session.get() : System.currentTimeMillis() + Random2.R.nextAlnum(18);
    }
}
