package ru.yandex.chemodan.app.dataapi.web.xiva;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.chemodan.app.dataapi.core.xiva.XivaUrlHelper;

/**
 * @author metal
 */
@Configuration
public class XivaSubscriptionActionContextConfiguration {
    @Bean
    public GetStreamSubscriptionUrlAction getStreamSubscriptionUrlAction(XivaUrlHelper xivaUrlHelper) {
        return new GetStreamSubscriptionUrlAction(xivaUrlHelper);
    }

    @Bean
    public GetApplicationSubscriptionUrlAction getApplicationSubscriptionUrlAction(XivaUrlHelper xivaUrlHelper) {
        return new GetApplicationSubscriptionUrlAction(xivaUrlHelper);
    }

    @Bean
    public GetCallbackSubscriptionUrlAction getCallbackSubscriptionUrlAction(XivaUrlHelper xivaUrlHelper) {
        return new GetCallbackSubscriptionUrlAction(xivaUrlHelper);
    }

    @Bean
    public XivaUrlHelper xivaUrlHelper(@Value("${xiva.host}") String xivaUrl,
            @Value("${xiva.ya-team.host}") String xivaYaTeamUrl) {
        return new XivaUrlHelper(xivaUrl, xivaYaTeamUrl);
    }
}
