package ru.yandex.chemodan.app.dataapi.worker;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.app.dataapi.core.datasources.migration.DsMigrationManager;
import ru.yandex.chemodan.app.dataapi.core.logbroker.LogBrokerPushRecordChangeTask;
import ru.yandex.chemodan.app.dataapi.core.logbroker.LogBrokerPushSender;
import ru.yandex.chemodan.app.dataapi.core.logbroker.LogBrokerPushSenderContextConfiguration;
import ru.yandex.chemodan.app.dataapi.maintenance.DatabasesTasksContextConfiguration;
import ru.yandex.chemodan.app.dataapi.worker.profile.ProfileTasksContextConfiguration;
import ru.yandex.chemodan.app.dataapi.worker.tasks.ConfigurableDataApiTasksContextConfiguration;
import ru.yandex.chemodan.app.dataapi.worker.tasks.DataSourceMigrationTask;
import ru.yandex.chemodan.bazinga.CronTaskWrapper;
import ru.yandex.commune.bazinga.BazingaConfiguration;
import ru.yandex.commune.bazinga.BazingaConfigurator;
import ru.yandex.commune.bazinga.impl.TaskId;
import ru.yandex.commune.bazinga.scheduler.CronTask;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.commune.bazinga.tasks.BazingaHeartbeatTask;
import ru.yandex.commune.zk2.client.ZkManager;

/**
 * @author tolmalev
 */
@Configuration
@Import({
        DatabasesTasksContextConfiguration.class,
        ProfileTasksContextConfiguration.class,
        LogBrokerPushSenderContextConfiguration.class,
        ConfigurableDataApiTasksContextConfiguration.class
})
public class DataApiTasksContextConfiguration {
    @Bean
    public CronTask bazingaHeartbeatTask(BazingaConfiguration bazingaConfiguration, ZkManager zkManager) {
        return new CronTaskWrapper(new BazingaHeartbeatTask(
                bazingaConfiguration,
                BazingaConfigurator.zkBazingaConfigurationStorage(bazingaConfiguration, zkManager)))
        {
            public TaskId id() {
                return new TaskId("bazingaHeartbeat.dataapi");
            }
            public TaskQueueName queueName() {
                return DataApiTaskQueueName.DATAAPI_CRON;
            }
        };
    }

    @Bean
    public DataSourceMigrationTask dataSourceMigrationTask(DsMigrationManager migrationManager) {
        return new DataSourceMigrationTask(migrationManager);
    }

    @Bean
    public LogBrokerPushRecordChangeTask logBrokerPushRecordChangeTask(LogBrokerPushSender sender) {
        return new LogBrokerPushRecordChangeTask(sender);
    }
}
