package ru.yandex.chemodan.app.dataapi.worker.dump;

import net.jodah.failsafe.RetryPolicy;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.core.datasources.disk.DiskDataSource;
import ru.yandex.chemodan.app.dataapi.core.manager.DataApiManager;
import ru.yandex.chemodan.app.dataapi.worker.tasks.ConfigurableDataApiTasksRegistry;
import ru.yandex.commune.bazinga.impl.worker.WorkerTaskRegistry;
import ru.yandex.commune.zk2.ZkPath;
import ru.yandex.inside.yt.kosher.Yt;

/**
 * @author metal
 */
public class DumpDatabaseCronTasksRegistry extends ConfigurableDataApiTasksRegistry<DumpDatabaseTask> {
    private static final String CRON_TASK_PREFIX = "dataapiDbDumpCronTask";

    private final DataApiManager dataApiManager;
    private final DiskDataSource diskDataSource;
    private final Yt yt;
    private final int maxNumberOfUsersInSingleChunk;
    private final int maxSkippedUsers;
    private final RetryPolicy dbRetryPolicy;
    private final RetryPolicy ytRetryPolicy;
    private final int threads;

    public DumpDatabaseCronTasksRegistry(ZkPath zkPath,
            DataApiManager dataApiManager,
            DiskDataSource diskDataSource,
            WorkerTaskRegistry workerTaskRegistry,
            Yt yt,
            int maxNumberOfUsersInSingleChunk,
            int maxSkippedUsers,
            RetryPolicy dbRetryPolicy,
            RetryPolicy ytRetryPolicy,
            int threads)
    {
        super(zkPath, DumpDatabaseTask.class, workerTaskRegistry);
        this.dataApiManager = dataApiManager;
        this.diskDataSource = diskDataSource;
        this.yt = yt;
        this.maxNumberOfUsersInSingleChunk = maxNumberOfUsersInSingleChunk;
        this.maxSkippedUsers = maxSkippedUsers;
        this.dbRetryPolicy = dbRetryPolicy;
        this.ytRetryPolicy = ytRetryPolicy;
        this.threads = threads;

    }

    @Override
    protected DumpDatabaseTask createCronTask(String taskName, String cronExpression, String timeout,
            String app, String dbId, Option<String> collectionId)
    {
        return new DumpDatabaseTask(taskName, cronExpression, timeout, app, dbId, collectionId);
    }

    @Override
    protected String addPrefixToTaskName(String userTaskName) {
        return CRON_TASK_PREFIX + userTaskName;
    }

    @Override
    protected void initializeTasks(ListF<DumpDatabaseTask> tasks) {
        for (DumpDatabaseTask task : tasks) {
            task.initializeProcessor(
                    dataApiManager,
                    diskDataSource,
                    yt,
                    dbRetryPolicy, ytRetryPolicy, maxNumberOfUsersInSingleChunk, maxSkippedUsers, threads);
        }
    }
}
