package ru.yandex.chemodan.app.dataapi.worker.dump;

import net.jodah.failsafe.RetryPolicy;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.core.datasources.disk.DiskDataSource;
import ru.yandex.chemodan.app.dataapi.core.manager.DataApiManager;
import ru.yandex.chemodan.app.dataapi.worker.tasks.ConfigurableDataApiTask;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.inside.yt.kosher.Yt;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.lang.DefaultToString;

/**
 * @author metal
 */
@Bendable
public class DumpDatabaseTask extends ConfigurableDataApiTask {
    private DumpDatabaseUsersProcessor dumpDatabaseUsersProcessor;

    public DumpDatabaseTask(String taskName, String cronExpression, String timeout,
            String app, String dbId, Option<String> collectionId)
    {
        super(taskName, cronExpression, timeout, app, dbId, collectionId);
    }

    public void initializeProcessor(
            DataApiManager dataApiManager,
            DiskDataSource diskDataSource,
            Yt yt,
            RetryPolicy dbRetryPolicy, RetryPolicy ytRetryPolicy,
            int maxNumberOfUsersInSingleChunk, int maxSkippedUsers, int threads)
    {
        dumpDatabaseUsersProcessor = new DumpDatabaseUsersProcessor(
                dataApiManager,
                diskDataSource,
                Option.of(app), dbId, collectionId, yt,
                maxNumberOfUsersInSingleChunk, maxSkippedUsers, dbRetryPolicy, ytRetryPolicy, threads);
    }

    @Override
    public void execute(ExecutionContext executionContext) throws Exception {
        dumpDatabaseUsersProcessor.process();

        int skippedUsers = dumpDatabaseUsersProcessor.getSkippedUsers();
        executionContext.setExecutionInfo(new SkippedUsersStat(skippedUsers));

        if (dumpDatabaseUsersProcessor.wereTooManyUsersSkipped()) {
            throw new TooManySkippedUsers();
        }
    }

    @BenderBindAllFields
    private static class SkippedUsersStat extends DefaultToString {
        public final int skippedUsers;

        public SkippedUsersStat(int skippedUsers) {
            this.skippedUsers = skippedUsers;
        }
    }
}
