package ru.yandex.chemodan.app.dataapi.worker.dump;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import net.jodah.failsafe.RetryPolicy;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.dataapi.core.datasources.disk.DiskDataSource;
import ru.yandex.chemodan.app.dataapi.core.manager.DataApiManager;
import ru.yandex.chemodan.app.dataapi.utils.YtPathsUtils;
import ru.yandex.inside.yt.kosher.Yt;
import ru.yandex.inside.yt.kosher.cypress.YPath;

/**
 * @author metal
 * @author vpronto
 */
public class DumpDatabaseUsersProcessor extends AbstractDumpDatabaseUsersProcessor {

    private static final String DUMPS_YT_PATH_PREFIX = "dumps";

    public DumpDatabaseUsersProcessor(
                DataApiManager dataApiManager,
                DiskDataSource diskDataSource,
                Option<String> app, String databaseId, Option<String> collectionId,
                Yt yt, int maxNumberOfUsersInSingleChunk, int maxSkippedUsers,
                RetryPolicy dbRetryPolicy, RetryPolicy ytRetryPolicy, int threads)
    {
        super(dataApiManager, diskDataSource, app, databaseId, collectionId, yt,
                maxNumberOfUsersInSingleChunk, maxSkippedUsers, dbRetryPolicy, ytRetryPolicy, threads);
    }

    protected JsonNode convertRecordToYtRow(DataApiUserId uid, JsonNode record) {
        ObjectNode row = jsonNodeFactory.objectNode();
        row.put("uid", uid.toString());
        row.set("record_id", record.get("record_id"));
        row.set("record_data", record.get("fields"));
        return row;
    }

    protected YPath getGeneralPath() {
        return YtPathsUtils.getProperYPath(DUMPS_YT_PATH_PREFIX, dbRef(), collectionId);
    }

    protected YPath getResultPath(String cols) {
        return YtPathsUtils.getProperYPathWithDate(DUMPS_YT_PATH_PREFIX, dbRef(), collectionId);
    }

}
