package ru.yandex.chemodan.app.dataapi.worker.dump.full;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import net.jodah.failsafe.RetryPolicy;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.dataapi.core.datasources.disk.DiskDataSource;
import ru.yandex.chemodan.app.dataapi.core.manager.DataApiManager;
import ru.yandex.chemodan.app.dataapi.utils.YtPathsUtils;
import ru.yandex.chemodan.app.dataapi.worker.dump.AbstractDumpDatabaseUsersProcessor;
import ru.yandex.inside.yt.kosher.Yt;
import ru.yandex.inside.yt.kosher.cypress.YPath;

/**
 * @author metal
 */
public class FullDumpDatabaseUsersProcessor extends AbstractDumpDatabaseUsersProcessor {
    public static final String DATASYNC_FULL_DUMP_YT_PATH_PREFIX = "fulldump";

    private static final JsonNodeFactory jsonNodeFactory = new JsonNodeFactory(false);

    public FullDumpDatabaseUsersProcessor(
            DataApiManager dataApiManager,
            DiskDataSource diskDataSource,
            Option<String> app, String databaseId, Option<String> collectionId,
            Yt yt, int maxNumberOfUsersInSingleChunk, int maxSkippedUsers,
            RetryPolicy dbRetryPolicy, RetryPolicy ytRetryPolicy, int threads)
    {
        super(dataApiManager, diskDataSource, app, databaseId, collectionId, yt,
                maxNumberOfUsersInSingleChunk, maxSkippedUsers, dbRetryPolicy, ytRetryPolicy, threads);
    }

    @Override
    protected JsonNode convertRecordToYtRow(DataApiUserId uid, JsonNode record) {
        ObjectNode ytRow = jsonNodeFactory.objectNode();
        ytRow.put("uid", uid.toString());
        ytRow.set("record_id", record.get("record_id"));
        ytRow.set("record_rev", record.get("revision"));
        ytRow.set("record_data", record.get("fields"));
        return ytRow;
    }

    @Override
    protected YPath getGeneralPath() {
        return YtPathsUtils.getProperYPath(DATASYNC_FULL_DUMP_YT_PATH_PREFIX, dbRef(), collectionId);
    }

    protected YPath getResultPath(String col) {
        return getCollectionYPath(col).child("current");
    }
}
