package ru.yandex.chemodan.app.dataapi.worker.dump.full;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.db.ref.DatabaseRef;
import ru.yandex.chemodan.app.dataapi.utils.YtPathsUtils;
import ru.yandex.inside.yt.kosher.Yt;
import ru.yandex.inside.yt.kosher.cypress.YPath;
import ru.yandex.inside.yt.kosher.ytree.YTreeNode;

/**
 * @author metal
 */
public class YtCollectionNamesExtractor implements CollectionNamesExtractor {
    private final Yt yt;
    private final String pathPrefix;

    public YtCollectionNamesExtractor(Yt yt, String pathPrefix) {
        this.yt = yt;
        this.pathPrefix = pathPrefix;
    }

    @Override
    public ListF<String> getCollectionNames(DatabaseRef databaseRef) {
        YPath path = YtPathsUtils.getProperYPath(pathPrefix, databaseRef, Option.empty());
        return Cf.wrap(yt.cypress()
                .get(path)
                .asMap())
                .filterValues(YTreeNode::isMapNode)
                .keys();
    }
}
