package ru.yandex.chemodan.app.dataapi.worker.dump.full;

import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.chemodan.app.dataapi.api.db.ref.AppDatabaseRef;
import ru.yandex.inside.yt.kosher.Yt;
import ru.yandex.inside.yt.kosher.cypress.Cypress;
import ru.yandex.inside.yt.kosher.cypress.YPath;
import ru.yandex.inside.yt.kosher.impl.ytree.YTreeEntityNodeImpl;
import ru.yandex.inside.yt.kosher.impl.ytree.YTreeMapNodeImpl;
import ru.yandex.inside.yt.kosher.ytree.YTreeNode;
import ru.yandex.misc.test.Assert;

import static org.mockito.Matchers.any;

/**
 * @author metal
 */
public class YtCollectionNamesExtractorTest {
    private static final AppDatabaseRef database = new AppDatabaseRef("test_app", "test_db");

    private static final String PREFIX = "fulldump";

    private Yt yt;

    @Before
    public void init() {
        Cypress cypress = Mockito.mock(Cypress.class);

        YTreeNode getResult = new YTreeMapNodeImpl(Cf.map());
        getResult.asMap().putAll(Cf.map(
                "collection1", new YTreeMapNodeImpl(Cf.map()),
                "collection2", new YTreeMapNodeImpl(Cf.map()),
                "collection3", new YTreeMapNodeImpl(Cf.map()),
                "some_table", new YTreeEntityNodeImpl(Cf.map())));

        Mockito
                .when(cypress.get(any(YPath.class)))
                .thenReturn(getResult);

        yt = Mockito.mock(Yt.class);
        Mockito
                .when(yt.cypress())
                .thenReturn(cypress);
    }

    @Test
    public void getCollectionNamesTest() {
        YtCollectionNamesExtractor extractor = new YtCollectionNamesExtractor(yt, PREFIX);
        Assert.assertListsEqual(
                Cf.list("collection1", "collection2", "collection3"),
                extractor.getCollectionNames(database));
    }
}
