package ru.yandex.chemodan.app.dataapi.worker.dump.full;

import net.jodah.failsafe.RetryPolicy;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.chemodan.app.dataapi.utils.YtPathsUtils;
import ru.yandex.chemodan.util.retry.RetryManager;
import ru.yandex.inside.yt.kosher.Yt;
import ru.yandex.inside.yt.kosher.cypress.CypressNodeType;
import ru.yandex.inside.yt.kosher.cypress.YPath;
import ru.yandex.inside.yt.kosher.impl.ytree.builder.YTree;
import ru.yandex.misc.io.InputStreamSourceUtils;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author metal
 */
public class YtDumpAndChangesMergeScriptManager {
    private static final Logger logger = LoggerFactory.getLogger(YtDumpAndChangesMergeScriptManager.class);

    public static final YPath MERGE_SCRIPT_YPATH = YtPathsUtils.getMergeScriptYPath();

    private final Yt yt;
    private final RetryPolicy ytRetryPolicy;
    private final String mergeScriptLocalPath;

    public YtDumpAndChangesMergeScriptManager(Yt yt, RetryPolicy ytRetryPolicy, String mergeScriptLocalPath) {
        this.yt = yt;
        this.ytRetryPolicy = ytRetryPolicy;
        this.mergeScriptLocalPath = mergeScriptLocalPath;
    }

    public void uploadMergeScriptInYt() {
        logger.info("Uploading merge dump and database changes logs script in yt");

        new RetryManager()
                .withRetryPolicy(ytRetryPolicy)
                .withLogging("Uploading merge script: " + MERGE_SCRIPT_YPATH)
                .run(() -> {
                    yt.cypress().create(MERGE_SCRIPT_YPATH, CypressNodeType.FILE, true, true,
                            Cf.map("executable", YTree.booleanNode(true)));
                    yt.files().write(MERGE_SCRIPT_YPATH, InputStreamSourceUtils.valueOf(mergeScriptLocalPath));
                });
    }
}
