package ru.yandex.chemodan.app.dataapi.worker.dump.full;

import org.joda.time.Duration;

import ru.yandex.chemodan.app.dataapi.worker.DataApiCronTask;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.schedule.Schedule;
import ru.yandex.commune.bazinga.scheduler.schedule.ScheduleCron;
import ru.yandex.commune.bazinga.scheduler.schedule.ScheduleWithRetry;
import ru.yandex.misc.time.TimeUtils;

/**
 * @author metal
 */
public class YtDumpConsistencySupporterTask extends DataApiCronTask {
    private static final Duration DEFAULT_TIMEOUT = Duration.standardMinutes(300);

    private final YtDumpConsistencyManager ytDumpConsistencyManager;

    public YtDumpConsistencySupporterTask(YtDumpConsistencyManager ytDumpConsistencyManager) {
        this.ytDumpConsistencyManager = ytDumpConsistencyManager;
    }

    @Override
    public Schedule cronExpression() {
        return new ScheduleWithRetry(new ScheduleCron("0 15 * * *", TimeUtils.EUROPE_MOSCOW_TIME_ZONE), 5);
    }

    @Override
    public Duration timeout() {
        return DEFAULT_TIMEOUT;
    }

    @Override
    public void execute(ExecutionContext executionContext) throws Exception {
        ytDumpConsistencyManager.updateDatabases();
    }
}
