import sys
import json


def do_decode(iterable):
    for line in iterable:
        table_row = json.loads(line)
        yield table_row


def compare_rows(row1, row2):
    return row1["uid"] == row2["uid"] and row1["record_id"] == row2["record_id"]


def sort_records(records):
    return sorted(records, key=lambda k: int(k.get('record_rev', 0)), reverse=True)


def print_result(yt_row):
    if "method" in yt_row:
        if yt_row["method"] != "delete":
            print json.dumps(
                {
                    "uid": yt_row["uid"],
                    "record_id": yt_row["record_id"],
                    "record_rev": yt_row["record_rev"],
                    "record_data": json.loads(yt_row["record_data"]),
                })
    else:
        print json.dumps(yt_row)


def do_map(yt_row_stream, application_id, database_id, collection_id):
    for yt_row in yt_row_stream:
        if ("uid" not in yt_row or
                "application_id" in yt_row and
                (yt_row["application_id"] != application_id or
                 yt_row["database_id"] != database_id or
                 yt_row["collection_id"] != collection_id)):
            continue
        else:
            print json.dumps(yt_row)


def do_reduce(yt_row_stream):
    grouped_rows = []
    for yt_row in yt_row_stream:
        if "uid" not in yt_row:
            continue

        if not grouped_rows:
            grouped_rows.append(yt_row)
            continue
        elif compare_rows(yt_row, grouped_rows[0]):
            grouped_rows.append(yt_row)
            continue
        else:
            grouped_rows = sort_records(grouped_rows)
            print_result(grouped_rows[0])

            grouped_rows = [yt_row]
    if grouped_rows:
        grouped_rows = sort_records(grouped_rows)
        print_result(grouped_rows[0])


if __name__ == "__main__":
    stream = sys.stdin
    stream = do_decode(stream)

    if len(sys.argv) >= 5 and sys.argv[1] == "map":
        script, operation, application_id, database_id, collection_id = sys.argv
        do_map(stream, application_id, database_id, collection_id)
    elif len(sys.argv) >= 2 and sys.argv[1] == "reduce":
        do_reduce(stream)
    else:
        print >> sys.stderr, "Please, specify proper map or reduce command to execute"
        sys.exit(1)
