package ru.yandex.chemodan.app.dataapi.worker.importer;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.worker.importer.readers.address.AddressChangesProcessor;
import ru.yandex.chemodan.app.dataapi.worker.tasks.ConfigurableDataApiTasksRegistry;
import ru.yandex.commune.bazinga.impl.worker.WorkerTaskRegistry;
import ru.yandex.commune.zk2.ZkPath;

/**
 * @author metal
 */
public class ImportDataCronTasksRegistry extends ConfigurableDataApiTasksRegistry<ImportDataTask> {
    private static final String CRON_TASK_PREFIX = "dataapiImportDataCronTask";

    private final AddressChangesProcessor addressChangesProcessor;

    public ImportDataCronTasksRegistry(ZkPath zkPath,
            WorkerTaskRegistry workerTaskRegistry,
            AddressChangesProcessor addressChangesProcessor)
    {
        super(zkPath, ImportDataTask.class, workerTaskRegistry);
        this.addressChangesProcessor = addressChangesProcessor;
    }

    @Override
    protected ImportDataTask createCronTask(String taskName, String cronExpression, String timeout,
            String app, String dbId, Option<String> collectionId)
    {
        return new ImportDataTask(taskName, cronExpression, timeout, app, dbId, collectionId);
    }

    @Override
    protected String addPrefixToTaskName(String userTaskName) {
        return CRON_TASK_PREFIX + userTaskName;
    }

    @Override
    protected void initializeTasks(ListF<ImportDataTask> tasks) {
        for (ImportDataTask task : tasks) {
            task.setImportDataProcessor(addressChangesProcessor);
        }
    }
}
