package ru.yandex.chemodan.app.dataapi.worker.importer;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.worker.importer.processors.ImportDataProcessor;
import ru.yandex.chemodan.app.dataapi.worker.tasks.ConfigurableDataApiTask;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.misc.bender.annotation.Bendable;

/**
 * @author metal
 */
@Bendable
public class ImportDataTask extends ConfigurableDataApiTask {
    private ImportDataProcessor importDataProcessor;

    public ImportDataTask(String taskName, String cronExpression, String timeout,
            String app, String dbId, Option<String> collectionId)
    {
        super(taskName, cronExpression, timeout, app, dbId, collectionId);
    }

    public void setImportDataProcessor(ImportDataProcessor importDataProcessor) {
        this.importDataProcessor = importDataProcessor;
    }

    @Override
    public void execute(ExecutionContext executionContext) {
        importDataProcessor.processImportData(app, dbId, collectionId);
    }
}
