package ru.yandex.chemodan.app.dataapi.worker.importer;

import org.joda.time.Duration;

import ru.yandex.chemodan.app.dataapi.utils.YtPathsUtils;
import ru.yandex.chemodan.app.dataapi.worker.DataApiTaskQueueName;
import ru.yandex.commune.bazinga.BazingaTaskManager;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.OnetimeTaskSupport;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.inside.yt.kosher.Yt;
import ru.yandex.inside.yt.kosher.cypress.CypressNodeType;
import ru.yandex.inside.yt.kosher.cypress.YPath;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author dbrylev
 */
public class ImportGenericObjectsTask extends OnetimeTaskSupport<ImportGenericObjectsTask.Parameters> {

    private BazingaTaskManager bazingaTaskManager;
    private Yt yt;
    private int importDataRowFetchCount;

    public ImportGenericObjectsTask(String typeName, String importId, String ypath) {
        super(new Parameters(typeName, importId, ypath));
    }

    public ImportGenericObjectsTask(BazingaTaskManager bazingaTaskManager, Yt yt, int importDataRowFetchCount) {
        super(Parameters.class);
        this.bazingaTaskManager = bazingaTaskManager;
        this.yt = yt;
        this.importDataRowFetchCount = importDataRowFetchCount;
    }

    @Override
    protected void execute(Parameters parameters, ExecutionContext context) throws Exception {
        yt.cypress().create(YtPathsUtils.getImportsResultsYPath(parameters.typeName, parameters.importId),
                CypressNodeType.TABLE, true, true);

        int count = yt.cypress().get(YPath.simple(parameters.ypath).attribute("row_count")).intValue();

        for (int i = 0; i <= count / importDataRowFetchCount; i++) {
            int lowerRowIndex = i * importDataRowFetchCount;
            int upperRowIndex = Math.min((i + 1) * importDataRowFetchCount, count);

            if (lowerRowIndex < upperRowIndex) {
                bazingaTaskManager.schedule(ImportDataChunkTask.genericTyped(
                        lowerRowIndex, upperRowIndex, parameters.ypath, parameters.typeName, parameters.importId));
            }
        }
    }

    @Override
    public int priority() {
        return 0;
    }

    @Override
    public Duration timeout() {
        return Duration.standardMinutes(5);
    }

    @Override
    public TaskQueueName queueName() {
        return DataApiTaskQueueName.DATAAPI_REGULAR;
    }

    @BenderBindAllFields
    public static class Parameters {
        private final String typeName;
        private final String importId;
        private final String ypath;

        public Parameters(String typeName, String importId, String ypath) {
            this.typeName = typeName;
            this.importId = importId;
            this.ypath = ypath;
        }
    }
}
