package ru.yandex.chemodan.app.dataapi.worker.importer.diff;

import net.jodah.failsafe.RetryPolicy;
import org.joda.time.LocalDate;
import org.joda.time.Period;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.dataapi.utils.YtPathsUtils;
import ru.yandex.chemodan.util.yt.IncrementalLogMrYtRunner;
import ru.yandex.chemodan.util.yt.YtCleaner;
import ru.yandex.chemodan.util.yt.YtRunnerBase;
import ru.yandex.inside.yt.kosher.Yt;
import ru.yandex.inside.yt.kosher.cypress.YPath;
import ru.yandex.inside.yt.kosher.operations.Operation;
import ru.yandex.inside.yt.kosher.operations.specs.CommandSpec;
import ru.yandex.inside.yt.kosher.operations.specs.MapReduceSpec;
import ru.yandex.misc.time.MoscowTime;

/**
 * @author dbrylev
 */
public class CalculateAddressesDiffRunner extends YtRunnerBase {

    private static final YPath DATASYNC_IMPORT_PATH = YtPathsUtils.getHomeYPath(
            "imports/profile/extracted_addresses/common_addresses");

    private static final YPath DATASYNC_DUMP_PATH = YtPathsUtils.getHomeYPath(
            "fulldump/profile/extracted_addresses/common_addresses/current");

    private static final YPath MINED_ADDRESSES_PATH = YPath.simple(
            "//home/user_identification/homework/v2/prod/homework_puid_with_addresses");

    private final YtCleaner ytCleaner;

    public CalculateAddressesDiffRunner(Yt yt, RetryPolicy retryPolicy, YPath rootPath, Period deletePeriod) {
        super(yt, retryPolicy, rootPath, "dataapi_calculate_addresses_diff");
        this.ytCleaner = new YtCleaner(yt, retryPolicy, deletePeriod);
    }

    public void calculate() {
        LocalDate today = MoscowTime.today();
        YPath resultPath = DATASYNC_IMPORT_PATH
                .child(today.toString())
                .withAdditionalAttributes(IncrementalLogMrYtRunner.COMPRESSION_ATTRIBUTES);

        ytCleaner.deleteOldAndGetLatestNotEmpty(DATASYNC_IMPORT_PATH, today);

        yt.runWithRetries(() -> mapReduce(
                Cf.list(DATASYNC_DUMP_PATH, MINED_ADDRESSES_PATH),
                resultPath).awaitAndThrowIfNotSuccess());
    }

    private Operation mapReduce(ListF<YPath> inputPaths, YPath outputPath) {
        CommandSpec mapCommandSpec = consBinaryCmd("map");
        CommandSpec reduceCommandSpec = consBinaryCmd("reduce");

        return yt.operations().mapReduceAndGetOp(MapReduceSpec.builder()
                .setInputTables(inputPaths)
                .setOutputTables(Cf.list(outputPath))
                .setMapperSpec(mapCommandSpec)
                .setReduceBy(Cf.list("id"))
                .setReducerSpec(reduceCommandSpec)
                .build());
    }
}
