package ru.yandex.chemodan.app.dataapi.worker.importer.diff;

import org.joda.time.Duration;

import ru.yandex.chemodan.app.dataapi.worker.DataApiCronTask;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.schedule.Schedule;
import ru.yandex.commune.bazinga.scheduler.schedule.ScheduleCron;
import ru.yandex.commune.bazinga.scheduler.schedule.ScheduleWithRetry;
import ru.yandex.misc.time.MoscowTime;

/**
 * @author dbrylev
 */
public class CalculateAddressesDiffTask extends DataApiCronTask {

    private final CalculateAddressesDiffRunner runner;

    public CalculateAddressesDiffTask(CalculateAddressesDiffRunner runner) {
        this.runner = runner;
    }

    @Override
    public void execute(ExecutionContext executionContext) throws Exception {
        runner.calculate();
    }

    @Override
    public Schedule cronExpression() {
        return new ScheduleWithRetry(new ScheduleCron("0 17 * * *", MoscowTime.TZ), 5);
    }

    @Override
    public Duration timeout() {
        return Duration.standardMinutes(30);
    }
}
