#!/usr/bin/python
import sys
import json
import itertools
import yt.yson as yson


def do_decode(lines):
    for line in lines:
        yield json.loads(line)


def do_map(rows):
    for row in rows:

        if row.get('record_data'):

            def get_data(field_id):
                for field in row.get('record_data'):
                    if field.get('field_id') == field_id:
                        return field['value'].get('string') or field['value'].get('double')

            print(json.dumps({
                'id': row.get('uid') + '/' + row.get('record_id'),
                'source': 'our',
                'puid': row.get('uid'),
                'type': row.get('record_id'),
                'address': get_data('address_line'),
                'short_address': get_data('address_line_short'),
                'lat': get_data('latitude'),
                'lon': get_data('longitude'),
            }))

        for type in ('home', 'work'):
            if 'predicted_' + type in row:
                data = yson.yson_to_json(row.get('predicted_' + type))

                if not data:
                    continue

                print(json.dumps({
                    'id': row.get('puid') + '/' + type,
                    'source': 'their',
                    'puid': row.get('puid'),
                    'type': type,
                    'address': data.get('address_full'),
                    'short_address': data.get('address_short'),
                    'lat': data.get('latitude'),
                    'lon': data.get('longitude'),
                }))


def do_reduce(rows):
    prev_row, group = {}, []

    for row in itertools.chain(rows, ({},)):
        if prev_row and prev_row.get('id') != row.get('id'):

            our = next((x for x in group if x.get('source') == 'our'), None)
            their = next((x for x in group if x.get('source') == 'their'), None)

            method = (
                'add' if not our else
                'remove' if not their else
                'change' if our.get('address') != their.get('address') else None)

            if method:
                res = (their or our).copy()
                res.pop('id')
                res.pop('source')
                res['method'] = method

                print(json.dumps(res))

            group = []

        group.append(row)
        prev_row = row


def main():
    stream = sys.stdin
    stream = do_decode(stream)

    if len(sys.argv) >= 2 and sys.argv[1] == "map":
        do_map(stream)
    elif len(sys.argv) >= 2 and sys.argv[1] == "reduce":
        do_reduce(stream)
    else:
        print("Please, specify proper map or reduce command to execute", file=sys.stderr)
        sys.exit(1)


if __name__ == "__main__":
    main()
