package ru.yandex.chemodan.app.dataapi.worker.importer.processors;

import net.jodah.failsafe.RetryPolicy;

import ru.yandex.bolts.function.Function2V;
import ru.yandex.chemodan.app.dataapi.api.db.Database;
import ru.yandex.chemodan.app.dataapi.api.db.ref.AppDatabaseRef;
import ru.yandex.chemodan.app.dataapi.api.db.ref.UserDatabaseSpec;
import ru.yandex.chemodan.app.dataapi.api.deltas.Delta;
import ru.yandex.chemodan.app.dataapi.api.deltas.RevisionCheckMode;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.dataapi.core.manager.DataApiManager;
import ru.yandex.chemodan.util.retry.RetryManager;

/**
 * @author metal
 */
public class BaseSingleDiffProcessorFactory implements SingleDiffProcessorFactory {
    private final DataApiManager dataApiManager;
    private final RetryPolicy dbRetryPolicy;

    public BaseSingleDiffProcessorFactory(DataApiManager dataApiManager, RetryPolicy dbRetryPolicy) {
        this.dataApiManager = dataApiManager;
        this.dbRetryPolicy = dbRetryPolicy;
    }

    @Override
    public Function2V<DataApiUserId, Delta> processSingleDiffF(String app, String dbId) {
        return (userId, delta) ->
                new RetryManager<Database>()
                        .withRetryPolicy(dbRetryPolicy)
                        .withLogging("Applying delta for user " + userId + " with database " + app + "." + dbId)
                        .runSafe(() -> doProcessSingleDiff(app, dbId, userId, delta));
    }

    private void doProcessSingleDiff(String app, String dbId, DataApiUserId userId, Delta delta) {
        UserDatabaseSpec databaseSpec = new UserDatabaseSpec(userId, new AppDatabaseRef(app, dbId));
        Database database = dataApiManager.getDatabase(databaseSpec);
        dataApiManager.applyDelta(database, RevisionCheckMode.PER_RECORD, delta);
    }
}
