package ru.yandex.chemodan.app.dataapi.worker.importer.readers.address;

import com.fasterxml.jackson.databind.JsonNode;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.dataapi.apps.profile.address.Address;
import ru.yandex.chemodan.app.dataapi.worker.importer.readers.DataRowParser;
import ru.yandex.misc.geo.Coordinates;

/**
 * @author metal
 */
public class AddressChangeJsonNodeParser implements DataRowParser<JsonNode, AddressChange> {
    public static final String USER_ID = "puid";
    public static final String TYPE = "type";
    public static final String METHOD = "method";
    public static final String ADDRESS = "address";
    public static final String SHORT_ADDRESS = "short_address";
    public static final String LATITUDE = "lat";
    public static final String LONGITUDE = "lon";

    @Override
    public AddressChange parse(JsonNode row) {
        String puid = row.get(USER_ID).asText();
        String type = row.get(TYPE).asText();
        String method = row.get(METHOD).asText();

        Option<String> addressLine = getColumnWithNullValues(row, ADDRESS);
        Option<String> addressLineShort = getColumnWithNullValues(row, SHORT_ADDRESS);

        double latitude = row.get(LATITUDE).asDouble();
        double longitude = row.get(LONGITUDE).asDouble();

        DataApiUserId userId = DataApiUserId.parse(puid);
        Option<Instant> now = Option.of(Instant.now());

        Address address = new Address(
                Option.of(type),
                "",
                new Coordinates(latitude, longitude),
                addressLine,
                addressLineShort,
                now,
                now,
                now,
                Cf.list(),
                Cf.list(),
                Option.empty(),
                Option.empty()
        );
        AddressChangeType addressChangeType = AddressChangeType.R.valueOf(method);

        return new AddressChange(userId, address, addressChangeType);
    }

    private Option<String> getColumnWithNullValues(JsonNode row, String columnName) {
        return Option
                .when(row.get(columnName) != null && !row.get(columnName).isNull(), () -> row.get(columnName))
                .map(JsonNode::asText);
    }
}
