package ru.yandex.chemodan.app.dataapi.worker.importer.readers.address;

import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.junit.Before;
import org.junit.Test;

import ru.yandex.misc.test.Assert;

/**
 * @author metal
 */
public class AddressChangeJsonNodeParserTest {
    private AddressChangeJsonNodeParser parser = new AddressChangeJsonNodeParser();
    private JsonNodeFactory jsonNodeFactory = new JsonNodeFactory(false);

    private ObjectNode node = jsonNodeFactory.objectNode();

    @Before
    public void init() {
        node.set(AddressChangeJsonNodeParser.USER_ID, jsonNodeFactory.textNode("123"));
        node.set(AddressChangeJsonNodeParser.TYPE, jsonNodeFactory.textNode("home"));
        node.set(AddressChangeJsonNodeParser.METHOD, jsonNodeFactory.textNode("add"));
        node.set(AddressChangeJsonNodeParser.ADDRESS, jsonNodeFactory.textNode("earth, address, 1"));
        node.set(AddressChangeJsonNodeParser.SHORT_ADDRESS, jsonNodeFactory.textNode("address, 1"));
        node.set(AddressChangeJsonNodeParser.LATITUDE, jsonNodeFactory.numberNode(51.423));
        node.set(AddressChangeJsonNodeParser.LONGITUDE, jsonNodeFactory.numberNode(75.365));
    }

    @Test
    public void parseWithAllFields() {
        AddressChange change = parser.parse(node);

        Assert.equals("123", change.uid.toString());
        Assert.equals(AddressChangeType.ADD, change.addressChangeType);
        Assert.equals("home", change.address.getAddressId().get());
        Assert.equals("earth, address, 1", change.address.getAddressLine().get());
        Assert.equals("address, 1", change.address.getAddressLineShort().get());
        Assert.equals(51.423, change.address.getLatitude());
        Assert.equals(75.365, change.address.getLongitude());
    }

    @Test
    public void parseWithEmptyFields() {
        node.set(AddressChangeJsonNodeParser.ADDRESS, jsonNodeFactory.nullNode());
        node.remove(AddressChangeJsonNodeParser.SHORT_ADDRESS);

        AddressChange change = parser.parse(node);

        Assert.equals("123", change.uid.toString());
        Assert.equals(AddressChangeType.ADD, change.addressChangeType);
        Assert.equals("home", change.address.getAddressId().get());
        Assert.assertFalse(change.address.getAddressLine().isPresent());
        Assert.assertFalse(change.address.getAddressLineShort().isPresent());
        Assert.equals(51.423, change.address.getLatitude());
        Assert.equals(75.365, change.address.getLongitude());
    }
}
