package ru.yandex.chemodan.app.dataapi.worker.importer.readers.address;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.data.record.CollectionRef;
import ru.yandex.chemodan.app.dataapi.worker.importer.processors.BaseImportDataProcessor;
import ru.yandex.chemodan.app.dataapi.worker.importer.readers.ypath.ImportDataYPathManager;
import ru.yandex.commune.bazinga.BazingaTaskManager;
import ru.yandex.inside.yt.kosher.Yt;
import ru.yandex.inside.yt.kosher.cypress.YPath;

/**
 * @author metal
 */
public class AddressChangesProcessor extends BaseImportDataProcessor {
    private static final String DEFAULT_EXTRACTED_ADDRESSES_COLLECTION = "common_addresses";
    private static final String ADDRESS_CHANGES_BASE_YPATH =
            "//home/user_identification/usergeo/production/state/datasync-export";

    private Option<String> path = Option.empty();

    public AddressChangesProcessor(BazingaTaskManager bazingaTaskManager,
            ImportDataYPathManager importDataYPathManager, int importDataRowFetchCount, Yt yt)
    {
        super(bazingaTaskManager, importDataYPathManager, importDataRowFetchCount, yt);
    }

    public void setPath(String path) {
        this.path = Option.of(path);
    }

    @Override
    protected String getDefaultCollectionId() {
        return DEFAULT_EXTRACTED_ADDRESSES_COLLECTION;
    }

    @Override
    protected YPath getDefaultImportFolder(CollectionRef collection) {
        return YPath.simple(path.getOrElse(ADDRESS_CHANGES_BASE_YPATH));
    }
}
