package ru.yandex.chemodan.app.dataapi.worker.importer.readers.generic;

import net.jodah.failsafe.RetryPolicy;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataField;
import ru.yandex.chemodan.app.dataapi.api.data.record.RecordRef;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.dataapi.core.dao.test.ActivateDataApiEmbeddedPg;
import ru.yandex.chemodan.app.dataapi.core.generic.TypeLocation;
import ru.yandex.chemodan.app.dataapi.core.manager.DataApiManager;
import ru.yandex.chemodan.app.dataapi.test.DataApiTestSupport;
import ru.yandex.misc.test.Assert;

/**
 * @author dbrylev
 */
@ActivateDataApiEmbeddedPg
public class GenericObjectChangeApplierTest extends DataApiTestSupport {

    private static final TypeLocation location = new TypeLocation(Option.of("gocat"), "db", "collection");
    private static final RecordRef recordRef = location.toColRef().consRecordRef("record");

    @Autowired
    private DataApiManager dataApiManager;
    private GenericObjectChangeApplier applier;

    private DataApiUserId uid;

    @Before
    public void setup() {
        uid = createRandomCleanUserInDefaultShard();
        applier = new GenericObjectChangeApplier(dataApiManager, new RetryPolicy());
    }

    @Test
    public void insertReplaceDelete() {
        Assert.none(dataApiManager.getRecord(uid, recordRef));

        applier.apply(new GenericObjectChange(
                uid, recordRef.recordId(), ChangeOperation.INSERT, Cf.map("data", DataField.string("data"))), location);

        Assert.some(dataApiManager.getRecord(uid, recordRef));

        applier.apply(new GenericObjectChange(
                uid, recordRef.recordId(), ChangeOperation.REPLACE, Cf.map("data", DataField.string("atad"))), location);

        Assert.equals(DataField.string("atad"), dataApiManager.getRecord(uid, recordRef).get().data().get("data"));

        applier.apply(new GenericObjectChange(
                uid, recordRef.recordId(), ChangeOperation.DELETE, Cf.map()), location);

        Assert.none(dataApiManager.getRecord(uid, recordRef));
    }

    @Test
    public void replaceInsert() {
        Assert.none(dataApiManager.getRecord(uid, recordRef));

        applier.apply(new GenericObjectChange(
                uid, recordRef.recordId(), ChangeOperation.REPLACE, Cf.map("data", DataField.string("atad"))), location);

        Assert.some(dataApiManager.getRecord(uid, recordRef));

        applier.apply(new GenericObjectChange(
                uid, recordRef.recordId(), ChangeOperation.INSERT, Cf.map("data", DataField.string("data"))), location);

        Assert.equals(DataField.string("atad"), dataApiManager.getRecord(uid, recordRef).get().data().get("data"));
    }

    @Test
    public void skipUnchangingReplace() {
        MapF<String, DataField> data = Cf.map("data", DataField.string("data"), "number", DataField.integer(10));

        applier.apply(new GenericObjectChange(uid, recordRef.recordId(), ChangeOperation.REPLACE, data), location);

        long rev = dataApiManager.getRecord(uid, recordRef).get().getRev();

        applier.apply(new GenericObjectChange(uid, recordRef.recordId(), ChangeOperation.REPLACE, data), location);

        Assert.equals(rev, dataApiManager.getRecord(uid, recordRef).get().getRev());
    }

    @Test
    public void deleteNonExisting() {
        Assert.none(dataApiManager.getRecord(uid, recordRef));

        applier.apply(new GenericObjectChange(
                uid, recordRef.recordId(), ChangeOperation.DELETE, Cf.map()), location);
    }
}
