package ru.yandex.chemodan.app.dataapi.worker.importer.readers.generic;

import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author dbrylev
 */
@BenderBindAllFields
public class ProcessingCounters {

    public int failed;
    public int unparsed;
    public int unapplied;

    public int succeeded;
    public int created;
    public int updated;
    public int deleted;
    public int skipped;

    public void incUnparsed() {
        failed++;
        unparsed++;
    }

    public void incUnapplied() {
        failed++;
        unapplied++;
    }

    public void incApplied(ApplyResult result) {
        succeeded++;

        if (result == ApplyResult.CREATED) {
            created++;
        } else if (result == ApplyResult.UPDATED) {
            updated++;
        } else if (result == ApplyResult.DELETED) {
            deleted++;
        } else if (result == ApplyResult.SKIPPED) {
            skipped++;
        }
    }

    public void plus(ProcessingCounters that) {
        failed += that.failed;
        unparsed += that.unparsed;
        unapplied += that.unapplied;

        succeeded += that.succeeded;
        created += that.created;
        updated += that.updated;
        deleted += that.deleted;
        skipped += that.skipped;
    }
}
