package ru.yandex.chemodan.app.dataapi.worker.importer.readers.generic;

import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderFlatten;

/**
 * @author dbrylev
 */
@BenderBindAllFields
public class ProcessingStats {
    @BenderFlatten
    public final ProcessingContext context;
    @BenderFlatten
    public final ProcessingCounters counters;

    public ProcessingStats(ProcessingContext context) {
        this.context = context;
        this.counters = new ProcessingCounters();
    }

    public void incUnparsed() {
        counters.incUnparsed();
    }

    public void incUnapplied() {
        counters.incUnapplied();
    }

    public void incApplied(ApplyResult result) {
        counters.incApplied(result);
    }
}
