package ru.yandex.chemodan.app.dataapi.worker.importer.readers.ypath;

import org.joda.time.DateTime;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.test.TestHelper;
import ru.yandex.commune.zk2.client.ZkManager;
import ru.yandex.inside.yt.kosher.cypress.YPath;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.test.Assert;

import static ru.yandex.chemodan.app.dataapi.utils.YtPathsUtils.YT_NODE_NAME_FORMATTER;
import static ru.yandex.chemodan.app.dataapi.worker.importer.readers.ypath.ImportDataYPathTestData.DEFAULT_IMPORT_DATA_YPATH;
import static ru.yandex.chemodan.app.dataapi.worker.importer.readers.ypath.ImportDataYPathTestData.OVERRIDDEN_IMPORT_DATA_YPATH;
import static ru.yandex.chemodan.app.dataapi.worker.importer.readers.ypath.ImportDataYPathTestData.YPATH_COLLECTION_REF;

/**
 * @author metal
 */
@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(classes = {
        ImportDataYPathTestConfiguration.class
})
@TestExecutionListeners(value = {
        DependencyInjectionTestExecutionListener.class
})
public class ImportDataYPathManagerTest {

    private static final Logger logger = LoggerFactory.getLogger(ImportDataYPathManagerTest.class);
    @Autowired
    private ZkManager zkManager;

    @Autowired
    private ImportDataYPathManager importDataYPathManager;

    @Autowired
    private ImportYPathOverridesRegistry importYPathOverridesRegistry;

    @Autowired
    private LastSuccessfulImportDateRegistry lastSuccessfulImportDateRegistry;

    @BeforeClass
    public static void initLogger() {
        TestHelper.initialize();
    }

    @Before
    public void init() {
        zkManager.waitUntilInitializedForTesting();

        try {
            lastSuccessfulImportDateRegistry.removeLastSuccessfulImportDate(YPATH_COLLECTION_REF);
            importYPathOverridesRegistry.removeYPathOverrides(YPATH_COLLECTION_REF);
        } catch (Exception e) {
            logger.info("skipping cleaning (used embedded zk)", e.getMessage());
        }

    }

    @Test
    public void getYPathsToImportFromWithForcedYPathTest() {
        importYPathOverridesRegistry.forceImportDataFrom(YPATH_COLLECTION_REF, Option.of(OVERRIDDEN_IMPORT_DATA_YPATH));

        ListF<YPath> paths =
                importDataYPathManager.getYPathsToImportFrom(YPATH_COLLECTION_REF, YPath.simple(DEFAULT_IMPORT_DATA_YPATH));
        Assert.equals(1, paths.size());
        Assert.equals(YPath.simple(OVERRIDDEN_IMPORT_DATA_YPATH), paths.get(0));
    }

    @Test
    public void getYPathsToImportFromTest() {
        lastSuccessfulImportDateRegistry.updateLastSuccessfulImportDate(YPATH_COLLECTION_REF, "2016-07-05");

        YPath defaultPath = YPath.simple(DEFAULT_IMPORT_DATA_YPATH);
        ListF<YPath> paths =
                importDataYPathManager.getYPathsToImportFrom(YPATH_COLLECTION_REF, defaultPath);
        Assert.equals(3, paths.size());
        Assert.equals(defaultPath.child("2016-07-10"), paths.get(0));
        Assert.equals(defaultPath.child("2016-07-20"), paths.get(1));
        Assert.equals(defaultPath.child("2016-07-30"), paths.get(2));

        lastSuccessfulImportDateRegistry.removeLastSuccessfulImportDate(YPATH_COLLECTION_REF);

        importYPathOverridesRegistry.setImportDataFolderPath(YPATH_COLLECTION_REF, Option.of(OVERRIDDEN_IMPORT_DATA_YPATH));

        paths = importDataYPathManager.getYPathsToImportFrom(YPATH_COLLECTION_REF, defaultPath);
        Assert.equals(2, paths.size());

        String tomorrow = YT_NODE_NAME_FORMATTER.print(DateTime.now().plusDays(1));
        Assert.equals(YPath.simple(OVERRIDDEN_IMPORT_DATA_YPATH).child(tomorrow), paths.get(0));
    }
}
