package ru.yandex.chemodan.app.dataapi.worker.importer.readers.ypath;

import org.joda.time.DateTime;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.chemodan.app.dataapi.test.TestConstants;
import ru.yandex.chemodan.util.ZkUtils;
import ru.yandex.chemodan.zk.configuration.ImportZkEmbeddedConfiguration;
import ru.yandex.commune.zk2.ZkPath;
import ru.yandex.commune.zk2.client.ZkManager;
import ru.yandex.inside.yt.kosher.Yt;
import ru.yandex.inside.yt.kosher.cypress.Cypress;
import ru.yandex.inside.yt.kosher.cypress.YPath;
import ru.yandex.inside.yt.kosher.impl.ytree.builder.YTree;
import ru.yandex.misc.env.EnvironmentType;

import static ru.yandex.chemodan.app.dataapi.utils.YtPathsUtils.YT_NODE_NAME_FORMATTER;
import static ru.yandex.chemodan.app.dataapi.worker.importer.readers.ypath.ImportDataYPathTestData.DEFAULT_IMPORT_DATA_YPATH;
import static ru.yandex.chemodan.app.dataapi.worker.importer.readers.ypath.ImportDataYPathTestData.OVERRIDDEN_IMPORT_DATA_YPATH;

/**
 * @author metal
 */
@Configuration
@ImportZkEmbeddedConfiguration
public class ImportDataYPathTestConfiguration {

    @Bean
    public ZkPath zkRoot() {
        return ZkUtils.rootPath(TestConstants.DATAAPI, EnvironmentType.TESTS);
    }

    @Bean
    public ImportYPathOverridesRegistry importYPathOverridesRegistry(
            @Qualifier("zkRoot")
            ZkPath zkRoot,
            ZkManager zkManager)
    {
        ImportYPathOverridesRegistry importYPathOverridesRegistry = new ImportYPathOverridesRegistry(
                zkRoot.child("datasync_import_data_ypath_overrides"));
        zkManager.addClient(importYPathOverridesRegistry);
        return importYPathOverridesRegistry;
    }

    @Bean
    public LastSuccessfulImportDateRegistry lastSuccessfulImportDateRegistry(
            @Qualifier("zkRoot")
            ZkPath zkRoot,
            ZkManager zkManager)
    {
        LastSuccessfulImportDateRegistry lastSuccessfulImportDateRegistry = new LastSuccessfulImportDateRegistry(
                zkRoot.child("datasync_import_data_last_success"));
        try {
            zkManager.addClient(lastSuccessfulImportDateRegistry);
        } catch (Exception e) {
            //ignore node exists
        }
        return lastSuccessfulImportDateRegistry;
    }

    @Bean
    public ImportDataYPathManager importDataYPathManager(
            LastSuccessfulImportDateRegistry lastSuccessfulImportDateRegistry,
            ImportYPathOverridesRegistry importYPathOverridesRegistry,
            Yt yt)
    {
        return new ImportDataYPathManager(lastSuccessfulImportDateRegistry, importYPathOverridesRegistry, yt);
    }

    @Bean
    public Yt yt() {
        Cypress cypress = Mockito.mock(Cypress.class);
        Mockito
                .when(cypress.list(YPath.simple(DEFAULT_IMPORT_DATA_YPATH)))
                .thenReturn(Cf.list(
                        YTree.stringNode("2016-06-10"),
                        YTree.stringNode("2016-07-20"),
                        YTree.stringNode("2016-06-30"),
                        YTree.stringNode("2016-07-10"),
                        YTree.stringNode("2016-06-20"),
                        YTree.stringNode("2016-07-30"),
                        YTree.stringNode("wrong_format")));

        String tomorrow = YT_NODE_NAME_FORMATTER.print(DateTime.now().plusDays(1));
        String dayAfterTomorrow = YT_NODE_NAME_FORMATTER.print(DateTime.now().plusDays(2));
        Mockito
                .when(cypress.list(YPath.simple(OVERRIDDEN_IMPORT_DATA_YPATH)))
                .thenReturn(Cf.list(
                        YTree.stringNode(tomorrow),
                        YTree.stringNode(dayAfterTomorrow)));

        Yt yt = Mockito.mock(Yt.class);
        Mockito
                .when(yt.cypress())
                .thenReturn(cypress);

        return yt;
    }
}
