package ru.yandex.chemodan.app.dataapi.worker.importer.readers.ypath;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.data.record.CollectionRef;
import ru.yandex.chemodan.app.dataapi.utils.DataApiZkRegistry;
import ru.yandex.chemodan.app.dataapi.worker.tasks.ZkTaskIdUtils;
import ru.yandex.commune.zk2.ZkPath;
import ru.yandex.commune.zk2.primitives.registry.ZkPathEscaping;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author metal
 */
public class ImportYPathOverridesRegistry
        extends DataApiZkRegistry<ImportYPathOverridesRegistry.ImportYPathOverridesPojo>
{
    public ImportYPathOverridesRegistry(ZkPath zkPath) {
        super(zkPath, ImportYPathOverridesPojo.class,
                p -> ZkTaskIdUtils.id(p.appId, p.databaseId, p.collectionId), ZkPathEscaping.asIs);
    }

    public void setImportDataFolderPath(CollectionRef collection, Option<String> importDataFolderPath) {
        setImportDataFolderPath(collection.dbAppId(), collection.databaseId(), Option.of(collection.collectionId),
                importDataFolderPath);
    }

    public void setImportDataFolderPath(String appId, String databaseId, Option<String> collectionId,
            Option<String> importDataFolderPath)
    {
        Option<String> forcedPath = getForcedImportDataFullPath(appId, databaseId, collectionId);
        setYPathOverrides(appId, databaseId, collectionId, importDataFolderPath, forcedPath);
    }

    public void forceImportDataFrom(CollectionRef collection, Option<String> forcedImportDataFullPath) {
        forceImportDataFrom(collection.dbAppId(), collection.databaseId(), Option.of(collection.collectionId),
                forcedImportDataFullPath);
    }

    public void forceImportDataFrom(String appId, String databaseId, Option<String> collectionId,
            Option<String> forcedImportDataFullPath)
    {
        Option<String> folderPath = getImportDataFolderPath(appId, databaseId, collectionId);
        setYPathOverrides(appId, databaseId, collectionId, folderPath, forcedImportDataFullPath);
    }

    public void setYPathOverrides(
            String appId, String databaseId, Option<String> collectionId,
            Option<String> importDataFolderPath, Option<String> forcedImportDataFullPath)
    {
        put(new ImportYPathOverridesPojo(appId, databaseId, collectionId,
                importDataFolderPath, forcedImportDataFullPath));
    }

    public Option<String> getForcedImportDataFullPath(CollectionRef collection) {
        return getForcedImportDataFullPath(
                collection.dbAppId(), collection.databaseId(), Option.of(collection.collectionId));
    }

    public Option<String> getForcedImportDataFullPath(String appId, String databaseId, Option<String> collectionId) {
        Option<ImportYPathOverridesPojo> overrides = getO(ZkTaskIdUtils.id(appId, databaseId, collectionId));
        return overrides.isPresent() && overrides.get().forcedImportDataFullPath.isPresent()
                ? overrides.get().forcedImportDataFullPath
                : Option.empty();
    }

    public Option<String> getImportDataFolderPath(CollectionRef collection) {
        return getImportDataFolderPath(
                collection.dbAppId(), collection.databaseId(), Option.of(collection.collectionId));
    }

    public Option<String> getImportDataFolderPath(String appId, String databaseId, Option<String> collectionId) {
        Option<ImportYPathOverridesPojo> overrides = getO(ZkTaskIdUtils.id(appId, databaseId, collectionId));
        return overrides.isPresent() && overrides.get().importDataFolderPath.isPresent()
                ? overrides.get().importDataFolderPath
                : Option.empty();
    }

    public void removeYPathOverrides(CollectionRef collection) {
        removeYPathOverrides(collection.dbAppId(), collection.databaseId(), Option.of(collection.collectionId));
    }

    public void removeYPathOverrides(String appId, String databaseId, Option<String> collectionId) {
        remove(ZkTaskIdUtils.id(appId, databaseId, collectionId));
    }

    @BenderBindAllFields
    public static final class ImportYPathOverridesPojo {
        public final String appId;
        public final String databaseId;
        public final Option<String> collectionId;
        public final Option<String> importDataFolderPath;
        public final Option<String> forcedImportDataFullPath;

        public ImportYPathOverridesPojo(String appId, String databaseId, Option<String> collectionId,
                Option<String> importDataFolderPath, Option<String> forcedImportDataFullPath)
        {
            this.appId = appId;
            this.databaseId = databaseId;
            this.collectionId = collectionId;
            this.importDataFolderPath = importDataFolderPath;
            this.forcedImportDataFullPath = forcedImportDataFullPath;
        }
    }
}
