package ru.yandex.chemodan.app.dataapi.worker.importer.readers.ypath;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;

import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.zk2.client.ZkManager;
import ru.yandex.devtools.test.annotations.YaIgnore;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.test.Assert;

import static ru.yandex.chemodan.app.dataapi.worker.importer.readers.ypath.ImportDataYPathTestData.COLLECTION_REF;

/**
 * @author metal
 */
@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(classes = {
        ImportDataYPathTestConfiguration.class
})
@TestExecutionListeners(value = {
        DependencyInjectionTestExecutionListener.class
})
public class ImportYPathOverridesRegistryTest {
    private static final Logger logger = LoggerFactory.getLogger(ImportYPathOverridesRegistryTest.class);
    private static final String IMPORT_DATA_FOLDER_PATH = "//home/datasync/testing/imports";
    private static final String FORCED_IMPORT_DATA_PATH = "//home/datasync/imports/testing";

    @Autowired
    private ZkManager zkManager;

    @Autowired
    private ImportYPathOverridesRegistry importYPathOverridesRegistry;

    @Before
    public void init() {
        zkManager.waitUntilInitializedForTesting();
        try {
            importYPathOverridesRegistry.removeYPathOverrides(COLLECTION_REF);
        } catch (Exception e) {
            logger.info("skipping cleaning {}", e.getMessage());
        }
    }

    //TODO: fix flashing ZkRegistry Not initialized java.lang.IllegalStateException: Not initialized
    @Test
    @YaIgnore
    public void importDataYPathOverridesTest() {
        checkForAbsence();

        importYPathOverridesRegistry.setImportDataFolderPath(COLLECTION_REF, Option.of(IMPORT_DATA_FOLDER_PATH));

        Option<String> folder = importYPathOverridesRegistry.getImportDataFolderPath(COLLECTION_REF);
        Assert.equals(IMPORT_DATA_FOLDER_PATH, folder.get());

        importYPathOverridesRegistry.forceImportDataFrom(COLLECTION_REF, Option.of(FORCED_IMPORT_DATA_PATH));

        folder = importYPathOverridesRegistry.getImportDataFolderPath(COLLECTION_REF);
        Assert.equals(IMPORT_DATA_FOLDER_PATH, folder.get());

        Option<String> forced = importYPathOverridesRegistry.getForcedImportDataFullPath(COLLECTION_REF);
        Assert.equals(FORCED_IMPORT_DATA_PATH, forced.get());

        importYPathOverridesRegistry.removeYPathOverrides(COLLECTION_REF);

        checkForAbsence();
    }

    private void checkForAbsence() {
        Option<String> folder = importYPathOverridesRegistry.getImportDataFolderPath(COLLECTION_REF);
        Assert.isFalse(folder.isPresent());
        Option<String> forced = importYPathOverridesRegistry.getForcedImportDataFullPath(COLLECTION_REF);
        Assert.isFalse(forced.isPresent());
    }
}
