package ru.yandex.chemodan.app.dataapi.worker.importer.readers.ypath;

import org.joda.time.DateTime;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.data.record.CollectionRef;
import ru.yandex.chemodan.app.dataapi.utils.DataApiZkRegistry;
import ru.yandex.chemodan.app.dataapi.worker.tasks.ZkTaskIdUtils;
import ru.yandex.commune.zk2.ZkPath;
import ru.yandex.commune.zk2.primitives.registry.ZkPathEscaping;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

import static ru.yandex.chemodan.app.dataapi.utils.YtPathsUtils.YT_NODE_NAME_FORMATTER;

/**
 * @author metal
 */
public class LastSuccessfulImportDateRegistry
        extends DataApiZkRegistry<LastSuccessfulImportDateRegistry.LastSuccessfulImportPojo>
{
    public LastSuccessfulImportDateRegistry(ZkPath zkPath) {
        super(zkPath, LastSuccessfulImportPojo.class,
                p -> ZkTaskIdUtils.id(p.appId, p.databaseId, p.collectionId), ZkPathEscaping.asIs);
    }

    public void updateLastSuccessfulImportDate(CollectionRef collection, String date) {
        updateLastSuccessfulImportDate(
                collection.dbAppId(), collection.databaseId(), Option.of(collection.collectionId), date);
    }

    public void updateLastSuccessfulImportDate(
            String appId, String databaseId, Option<String> collectionId, String date)
    {
        put(new LastSuccessfulImportPojo(appId, databaseId, collectionId, date));
    }

    public String getLastSuccessfulImportDate(CollectionRef collection) {
        return getLastSuccessfulImportDate(
                collection.dbAppId(), collection.databaseId(), Option.of(collection.collectionId));
    }

    public String getLastSuccessfulImportDate(String appId, String databaseId, Option<String> collectionId) {
        return getO(ZkTaskIdUtils.id(appId, databaseId, collectionId))
                .map(p -> p.date).getOrElse(YT_NODE_NAME_FORMATTER.print(DateTime.now()));
    }

    public void removeLastSuccessfulImportDate(CollectionRef collection) {
        removeLastSuccessfulImportDate(collection.dbAppId(), collection.databaseId(), Option.of(collection.collectionId));
    }

    public void removeLastSuccessfulImportDate(String appId, String databaseId, Option<String> collectionId) {
        remove(ZkTaskIdUtils.id(appId, databaseId, collectionId));
    }

    @BenderBindAllFields
    public static final class LastSuccessfulImportPojo {
        public final String appId;
        public final String databaseId;
        public final Option<String> collectionId;
        public final String date;

        public LastSuccessfulImportPojo(String appId, String databaseId, Option<String> collectionId, String date) {
            this.appId = appId;
            this.databaseId = databaseId;
            this.collectionId = collectionId;
            this.date = date;
        }
    }
}
