package ru.yandex.chemodan.app.dataapi.worker.importer.readers.ypath;

import org.joda.time.DateTime;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;

import ru.yandex.commune.zk2.client.ZkManager;
import ru.yandex.devtools.test.annotations.YaIgnore;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.test.Assert;

import static ru.yandex.chemodan.app.dataapi.utils.YtPathsUtils.YT_NODE_NAME_FORMATTER;
import static ru.yandex.chemodan.app.dataapi.worker.importer.readers.ypath.ImportDataYPathTestData.COLLECTION_REF;

/**
 * @author metal
 */
@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(classes = {
        ImportDataYPathTestConfiguration.class
})
@TestExecutionListeners(value = {
        DependencyInjectionTestExecutionListener.class
})
public class LastSuccessfulImportDateRegistryTest {
    private static final Logger logger = LoggerFactory.getLogger(LastSuccessfulImportDateRegistryTest.class);
    private static final String LAST_SUCCESSFUL_IMPORT_DATE = "2016-07-14";
    private static final String NEXT_LAST_SUCCESSFUL_IMPORT_DATE = "2016-07-16";

    @Autowired
    private ZkManager zkManager;

    @Autowired
    private LastSuccessfulImportDateRegistry lastSuccessfulImportDateRegistry;

    @Before
    public void init() {
        zkManager.waitUntilInitializedForTesting();
        try {
            lastSuccessfulImportDateRegistry.removeLastSuccessfulImportDate(COLLECTION_REF);
        } catch (Exception e) {
            logger.info("skipping cleaning {}", e.getMessage());
        }
    }

    //TODO: fix flashing ZkRegistry Not initialized java.lang.IllegalStateException: Not initialized
    @Test
    @YaIgnore
    public void lastSuccessfulImportDateManipulationsTest() {
        String today = YT_NODE_NAME_FORMATTER.print(DateTime.now());
        String date = lastSuccessfulImportDateRegistry.getLastSuccessfulImportDate(COLLECTION_REF);
        Assert.equals(today, date);

        lastSuccessfulImportDateRegistry.updateLastSuccessfulImportDate(COLLECTION_REF, LAST_SUCCESSFUL_IMPORT_DATE);

        date = lastSuccessfulImportDateRegistry.getLastSuccessfulImportDate(COLLECTION_REF);
        Assert.equals(LAST_SUCCESSFUL_IMPORT_DATE, date);

        lastSuccessfulImportDateRegistry.updateLastSuccessfulImportDate(COLLECTION_REF, NEXT_LAST_SUCCESSFUL_IMPORT_DATE);

        date = lastSuccessfulImportDateRegistry.getLastSuccessfulImportDate(COLLECTION_REF);
        Assert.equals(NEXT_LAST_SUCCESSFUL_IMPORT_DATE, date);

        lastSuccessfulImportDateRegistry.removeLastSuccessfulImportDate(COLLECTION_REF);

        date = lastSuccessfulImportDateRegistry.getLastSuccessfulImportDate(COLLECTION_REF);
        Assert.equals(today, date);
    }
}
