package ru.yandex.chemodan.app.dataapi.worker.profile;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

import ru.yandex.chemodan.app.dataapi.apps.profile.address.AddressManager;
import ru.yandex.chemodan.app.dataapi.apps.profile.address.SetAddressLinesFromGeocoderTask;
import ru.yandex.chemodan.app.dataapi.apps.profile.events.ActualEventsManager;
import ru.yandex.chemodan.app.dataapi.apps.profile.events.RemoveOutdatedEventTask;

/**
 * @author tolmalev
 */
@Profile("dataapi")
@Configuration
public class ProfileTasksContextConfiguration {
    @Bean
    public RemoveOutdatedEventTask removeOutdatedEventTask(ActualEventsManager actualEventsManager) {
        return new RemoveOutdatedEventTask(actualEventsManager);
    }

    @Bean
    public SetAddressLinesFromGeocoderTask setAddressLinesFromGeocoderTask(AddressManager addressesManager) {
        return new SetAddressLinesFromGeocoderTask(addressesManager);
    }
}
