package ru.yandex.chemodan.app.dataapi.worker.tasks;

import org.joda.time.Duration;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.ConfigurableTaskUtils;
import ru.yandex.chemodan.app.dataapi.worker.DataApiCronTask;
import ru.yandex.commune.bazinga.impl.TaskId;
import ru.yandex.commune.bazinga.scheduler.schedule.Schedule;
import ru.yandex.commune.bazinga.scheduler.schedule.ScheduleCron;
import ru.yandex.commune.bazinga.scheduler.schedule.ScheduleWithRetry;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderPart;

/**
 * @author metal
 */
@Bendable
public abstract class ConfigurableDataApiTask extends DataApiCronTask {
    private static final Duration DEFAULT_TIMEOUT = Duration.standardMinutes(300);

    @BenderPart
    protected final String taskName;
    @BenderPart
    protected final String cronExpression;
    @BenderPart
    protected final String timeout;
    @BenderPart
    protected final String app;
    @BenderPart
    protected final String dbId;
    @BenderPart
    protected final Option<String> collectionId;

    public ConfigurableDataApiTask(String taskName, String cronExpression, String timeout,
            String app, String dbId, Option<String> collectionId)
    {
        this.taskName = taskName;
        this.cronExpression = cronExpression;
        this.timeout = timeout;
        this.app = app;
        this.dbId = dbId;
        this.collectionId = collectionId;
    }

    @Override
    public Duration timeout() {
        return ConfigurableTaskUtils.parseTimeout(timeout).getOrElse(DEFAULT_TIMEOUT);
    }

    @Override
    public Schedule cronExpression() {
        return new ScheduleWithRetry(
                new ScheduleCron(cronExpression, ru.yandex.misc.time.TimeUtils.EUROPE_MOSCOW_TIME_ZONE),
                5);
    }

    @Override
    public TaskId id() {
        return new TaskId(taskName);
    }
}
