package ru.yandex.chemodan.app.dataapi.worker.tasks;

import java.util.concurrent.TimeUnit;

import net.jodah.failsafe.RetryPolicy;
import org.joda.time.Duration;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.chemodan.app.dataapi.DataApiYtContextConfiguration;
import ru.yandex.chemodan.app.dataapi.worker.dump.DumpConfiguration;
import ru.yandex.chemodan.app.dataapi.worker.importer.ImportDataConfiguration;
import ru.yandex.commune.zk2.client.ZkManagerContextConfiguration;
import ru.yandex.misc.thread.InterruptedRuntimeException;
import ru.yandex.misc.thread.ThreadLocalTimeoutException;

/**
 * @author metal
 */
@Configuration
@Import({
        ZkManagerContextConfiguration.class,
        DumpConfiguration.class,
        ImportDataConfiguration.class,
        DataApiYtContextConfiguration.class,
})
public class ConfigurableDataApiTasksContextConfiguration {
    @Bean
    public RetryPolicy databaseOperationRetryPolicy(
            @Value("${dataapi.export-import.database.operation.retry.count}")
            int databaseOperationRetryCount,
            @Value("${dataapi.export-import.database.operation.retry.delay}")
            Duration databaseOperationRetryDelay)
    {
        return new RetryPolicy()
                .withMaxRetries(databaseOperationRetryCount)
                .withDelay(databaseOperationRetryDelay.getMillis(), TimeUnit.MILLISECONDS)
                .abortOn(Cf.list(VirtualMachineError.class, ThreadLocalTimeoutException.class, InterruptedRuntimeException.class));
    }

    @Bean
    public RetryPolicy ytOperationRetryPolicy(
            @Value("${dataapi.export-import.yt.operation.retry.count}")
            int ytOperationRetryCount,
            @Value("${dataapi.export-import.yt.operation.retry.delay}")
            Duration ytOperationRetryDelay)
    {
        return new RetryPolicy()
                .withMaxRetries(ytOperationRetryCount)
                .withDelay(ytOperationRetryDelay.getMillis(), TimeUnit.MILLISECONDS)
                .abortOn(Cf.list(VirtualMachineError.class, ThreadLocalTimeoutException.class, InterruptedRuntimeException.class));
    }
}
