package ru.yandex.chemodan.app.dataapi.worker.tasks;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.CollectionF;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.chemodan.app.dataapi.utils.DataApiZkRegistry;
import ru.yandex.commune.bazinga.impl.worker.WorkerTaskRegistry;
import ru.yandex.commune.zk2.ZkPath;
import ru.yandex.commune.zk2.primitives.registry.ZkPathEscaping;

/**
 * @author metal
 */
public abstract class ConfigurableDataApiTasksRegistry<T extends ConfigurableDataApiTask> extends DataApiZkRegistry<T> {
    private WorkerTaskRegistry workerTaskRegistry;

    public ConfigurableDataApiTasksRegistry(ZkPath zkPath, Class<T> elementClass,
            WorkerTaskRegistry workerTaskRegistry)
    {
        super(zkPath, elementClass, task -> ZkTaskIdUtils.id(task.app, task.dbId, task.collectionId), ZkPathEscaping.asIs);
        this.workerTaskRegistry = workerTaskRegistry;
    }

    protected abstract T createCronTask(String taskName, String cronExpression, String timeout,
            String app, String dbId, Option<String> collectionId);

    protected abstract String addPrefixToTaskName(String userTaskName);

    protected abstract void initializeTasks(ListF<T> tasks);

    @Override
    protected void handleNewState(CollectionF<T> allElements) {
        ListF<T> newTasks = Cf
                .toList(allElements)
                .filter(task -> !workerTaskRegistry.cronTaskExistF().apply(task.id()));

        initializeTasks(newTasks);

        workerTaskRegistry.addTasks(newTasks.toMap(task -> new Tuple2<>(task.id(), task)), Cf.map(), Cf.map());
    }

    public void addCronTask(String taskName, String cronExpression, String timeout,
            String app, String dbId, Option<String> collectionId)
    {
        put(createCronTask(addPrefixToTaskName(taskName), cronExpression, timeout, app, dbId, collectionId));
    }

    public void removeCronTask(String app, String dbId, Option<String> collectionId) {
        remove(ZkTaskIdUtils.id(app, dbId, collectionId));
    }
}
